/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ts.ui.ToolRunnableDecorator;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.ToolRegistry;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.NicoUIMessages;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.statushandlers.StatusManager;

public class NicoUITools {
    public static void startConsoleLazy(final NIConsole console, final IWorkbenchPage page, final boolean pin) {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                ToolProcess process = console.getProcess();
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (event.getSource() == process) {
                        switch (event.getKind()) {
                            case 8: {
                                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                            }
                        }
                    }
                    if (event.getSource() == process.getQueue() && Queue.isStateChange((DebugEvent)event)) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
                        ToolRegistry registry = NicoUIPlugin.getInstance().getToolRegistry();
                        registry.showConsoleExplicitly(console, page, pin);
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    public static @Nullable Tool getTool(IWorkbenchPart workbenchPart) {
        Tool tool = (Tool)workbenchPart.getAdapter(Tool.class);
        if (tool != null) {
            return tool;
        }
        return NicoUIPlugin.getInstance().getToolRegistry().getActiveToolSession(workbenchPart.getSite().getPage()).getTool();
    }

    public static @Nullable NIConsole getConsole(ToolProcess process) {
        IConsole[] consoles;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            NIConsole nico;
            IConsole console = iConsoleArray[n2];
            if (console instanceof NIConsole && process.equals((nico = (NIConsole)console).getProcess())) {
                return nico;
            }
            ++n2;
        }
        return null;
    }

    public static @Nullable NIConsole getConsole(WorkbenchToolSessionData session) {
        Object console = session.getConsole();
        return console instanceof NIConsole ? (NIConsole)((Object)console) : null;
    }

    public static void accessTool(String type, @Nullable Tool tool) throws CoreException {
        if (tool == null || type != null && !type.equals(tool.getMainType())) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, type != null ? NLS.bind((String)"No session of {0} is active in the current workbench window.", (Object)type) : "No tool session is active in the current workbench window.", null));
        }
    }

    public static boolean isToolReady(String type, String featureSetID, @Nullable Tool tool) {
        return tool != null && !tool.isTerminated() && tool.getMainType() == type && tool.isProvidingFeatureSet(featureSetID);
    }

    public static <W extends ToolWorkspace> ToolController accessController(String type, Tool tool) throws CoreException {
        return NicoUITools.accessController(type, null, tool);
    }

    public static <W extends ToolWorkspace> ToolController accessController(String type, String featureSetId, Tool tool) throws CoreException {
        NicoUITools.accessTool(type, tool);
        if (featureSetId != null && !tool.isProvidingFeatureSet(featureSetId) || !(tool instanceof ToolProcess)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, NLS.bind((String)"The active session of {0} ''{1}'' doesn't support allow required features.", (Object)type, (Object)tool.getLabel(0)), null));
        }
        ToolController controller = ((ToolProcess)tool).getController();
        if (controller == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, NLS.bind((String)"The active session of {0} ''{1}'' was terminated.", (Object)type, (Object)tool.getLabel(0)), null));
        }
        return controller;
    }

    public static <W extends ToolWorkspace> ToolController getController(String type, String featureSetId, ToolProcess process) {
        if (process == null || type != null && !type.equals(process.getMainType())) {
            return null;
        }
        ToolController controller = process.getController();
        if (controller == null) {
            return null;
        }
        if (featureSetId != null && !process.isProvidingFeatureSet(featureSetId)) {
            return null;
        }
        return controller;
    }

    public static IConsoleView getConsoleView(NIConsole console, IWorkbenchPage page) {
        ToolRegistry registry = NicoUIPlugin.getInstance().getToolRegistry();
        return registry.getConsoleView(console, page);
    }

    public static void showConsole(NIConsole console, IWorkbenchPage page, boolean activate) {
        ToolRegistry registry = NicoUIPlugin.getInstance().getToolRegistry();
        registry.showConsole(console, page, activate);
    }

    public static String createSubmitMessage(ToolProcess process) {
        return NLS.bind((String)NicoUIMessages.SubmitTask_name, (Object)process.getLabel(0));
    }

    public static void runSubmitInBackground(ToolProcess process, IRunnableWithProgress runnable, Shell shell) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, NLS.bind((String)NicoUIMessages.Submit_error_message, (Object)process.getLabel(1)), e.getCause()), 3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Image getImage(ToolProcess process) {
        ILaunchConfiguration configuration = process.getLaunch().getLaunchConfiguration();
        if (configuration != null) {
            try {
                ILaunchConfigurationType type = configuration.getType();
                return DebugUITools.getImage((String)type.getIdentifier());
            }
            catch (CoreException e) {
                NicoUIPlugin.logError(-1, "An error occurred when loading images", e);
            }
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ToolProcess process) {
        ILaunchConfiguration configuration = process.getLaunch().getLaunchConfiguration();
        if (configuration != null) {
            try {
                ILaunchConfigurationType type = configuration.getType();
                return DebugUITools.getImageDescriptor((String)type.getIdentifier());
            }
            catch (CoreException e) {
                NicoUIPlugin.logError(-1, "An error occurred when loading images", e);
            }
        }
        return null;
    }

    public static Image getImage(ToolRunnable runnable) {
        if (runnable == null) {
            return null;
        }
        Image image = null;
        if (runnable instanceof ToolRunnableDecorator) {
            image = ((ToolRunnableDecorator)runnable).getImage();
        }
        if (image == null) {
            NicoUIPlugin plugin = NicoUIPlugin.getInstance();
            ToolRunnableDecorator decorator = plugin.getUIDecoratorsRegistry().getDecoratorForRunnable(runnable.getTypeId());
            if (decorator != null) {
                image = decorator.getImage();
            }
            if (image == null) {
                image = plugin.getImageRegistry().get("org.eclipse.statet.nico.ui/image/obj/task.commanddummy");
            }
        }
        return image;
    }

    public static IViewPart getView(String viewId, Tool tool, boolean createNew) throws PartInitException {
        IViewPart view = null;
        IWorkbenchPage toolPage = NicoUI.getToolRegistry().findWorkbenchPage(tool);
        view = toolPage.findView(viewId);
        if (view != null) {
            view.getViewSite().getPage().activate((IWorkbenchPart)view);
            return view;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchToolSessionData session;
            IWorkbenchPage page = windows[i].getActivePage();
            if (page != toolPage && (session = NicoUI.getToolRegistry().getActiveToolSession(page)).getTool() == tool && (view = page.findView(viewId)) != null) {
                view.getViewSite().getPage().activate((IWorkbenchPart)view);
                return view;
            }
            ++i;
        }
        if (!createNew) {
            return null;
        }
        return toolPage.showView(viewId);
    }
}

