/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class SourceEditorProgressHandler
extends AbstractHandler {
    private final ISourceEditor editor;

    public SourceEditorProgressHandler(ISourceEditor editor) {
        this.editor = editor;
    }

    protected abstract String getTaskLabel();

    protected abstract boolean isEditTask();

    protected ISourceEditor getEditor(Object context) {
        return this.editor;
    }

    public void setEnabled(Object evaluationContext) {
        ISourceEditor editor = this.getEditor(evaluationContext);
        this.setBaseEnabled(editor != null && (!this.isEditTask() || editor.isEditable(false)));
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final ISourceEditor editor = this.getEditor(event.getApplicationContext());
        if (editor == null) {
            return null;
        }
        if (!editor.isEditable(true)) {
            return null;
        }
        final ISourceUnit su = editor.getSourceUnit();
        final ITextSelection selection = (ITextSelection)editor.getViewer().getSelection();
        if (su == null || selection == null) {
            return null;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SourceEditorProgressHandler.this.doExecute(editor, su, selection, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, NLS.bind((String)EditingMessages.GenericAction_error_message, (Object)this.getTaskLabel()), e.getTargetException()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected abstract void doExecute(ISourceEditor var1, ISourceUnit var2, ITextSelection var3, IProgressMonitor var4) throws Exception;
}

