/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class TextViewerCustomCaretSupport {
    private static final int WIDE_CARET_WIDTH = 2;
    private static final int SINGLE_CARET_WIDTH = 1;
    private final TextViewer fTextViewer;
    private final IPreferenceStore fPreferenceStore;
    private final IPropertyChangeListener fPreferencePropertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("AbstractTextEditor.Accessibility.UseCustomCarets".equals(property) || "AbstractTextEditor.Accessibility.WideCaret".equals(property)) {
                TextViewerCustomCaretSupport.this.updateCaret();
            }
        }
    };
    private final IPropertyChangeListener fFontPropertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("org.eclipse.jface.textfont".equals(property)) {
                TextViewerCustomCaretSupport.this.updateCaret();
            }
        }
    };
    private boolean fIsOverwriting = false;
    private Caret fNonDefaultCaret;
    private Image fNonDefaultCaretImage;
    private Caret fInitialCaret;

    public TextViewerCustomCaretSupport(TextViewer textViewer, IPreferenceStore preferences) {
        if (textViewer == null || preferences == null) {
            throw new NullPointerException();
        }
        this.fTextViewer = textViewer;
        this.fPreferenceStore = preferences;
        this.fTextViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextViewerCustomCaretSupport.this.dispose();
            }
        });
        this.fPreferenceStore.addPropertyChangeListener(this.fPreferencePropertyListener);
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyListener);
        this.updateCaret();
    }

    public void initActions(IHandlerService handlerService) {
        this.fTextViewer.getTextWidget().setKeyBinding(0x1000009, 0);
        handlerService.activateHandler("org.eclipse.ui.edit.text.toggleOverwrite", (IHandler)new ToggleOverwriteHandler());
    }

    private void toggleOverwriteMode() {
        if (this.isOverwriteEnabled()) {
            this.fIsOverwriting = !this.fIsOverwriting;
            this.fTextViewer.getTextWidget().invokeAction(0x1000009);
            this.updateCaret();
        }
    }

    private boolean isOverwriteEnabled() {
        return true;
    }

    private int getCaretWidthPreference() {
        return this.fPreferenceStore.getBoolean("AbstractTextEditor.Accessibility.WideCaret") ? 2 : 1;
    }

    private void updateCaret() {
        if (this.fTextViewer == null) {
            return;
        }
        StyledText styledText = this.fTextViewer.getTextWidget();
        ITextEditorExtension3.InsertMode mode = ITextEditorExtension3.SMART_INSERT;
        styledText.setCaret(null);
        this.disposeNonDefaultCaret();
        if (!this.fPreferenceStore.getBoolean("AbstractTextEditor.Accessibility.UseCustomCarets")) {
            assert (this.fNonDefaultCaret == null);
        } else if (this.fIsOverwriting) {
            this.fNonDefaultCaret = this.createOverwriteCaret(styledText);
        } else if (mode == ITextEditorExtension3.SMART_INSERT) {
            this.fNonDefaultCaret = this.createInsertCaret(styledText);
        } else if (mode == ITextEditorExtension3.INSERT) {
            this.fNonDefaultCaret = this.createRawInsertModeCaret(styledText);
        }
        if (this.fNonDefaultCaret != null) {
            styledText.setCaret(this.fNonDefaultCaret);
            this.fNonDefaultCaretImage = this.fNonDefaultCaret.getImage();
        } else if (this.fInitialCaret != styledText.getCaret()) {
            styledText.setCaret(this.fInitialCaret);
        }
    }

    private Caret createInsertCaret(StyledText styledText) {
        Caret caret = new Caret((Canvas)styledText, 0);
        caret.setSize(this.getCaretWidthPreference(), styledText.getLineHeight());
        caret.setFont(styledText.getFont());
        return caret;
    }

    private Caret createRawInsertModeCaret(StyledText styledText) {
        Caret caret = new Caret((Canvas)styledText, 0);
        Image image = this.createRawInsertModeCaretImage(styledText);
        if (image != null) {
            caret.setImage(image);
        } else {
            caret.setSize(this.getCaretWidthPreference(), styledText.getLineHeight());
        }
        caret.setFont(styledText.getFont());
        return caret;
    }

    private Image createRawInsertModeCaretImage(StyledText styledText) {
        PaletteData caretPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        int width = this.getCaretWidthPreference();
        int widthOffset = width - 1;
        ImageData imageData = new ImageData(4 + widthOffset, styledText.getLineHeight(), 1, caretPalette);
        Display display = styledText.getDisplay();
        Image bracketImage = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)bracketImage);
        gc.setForeground(display.getSystemColor(1));
        gc.setLineWidth(0);
        int height = imageData.height / 3;
        int i = 0;
        while (i < width) {
            gc.drawLine(i, 0, i, height - 1);
            gc.drawLine(i, imageData.height - height, i, imageData.height - 1);
            ++i;
        }
        gc.dispose();
        return bracketImage;
    }

    private Caret createOverwriteCaret(StyledText styledText) {
        Caret caret = new Caret((Canvas)styledText, 0);
        GC gc = new GC((Drawable)styledText);
        Point charSize = gc.stringExtent("a");
        caret.setSize(charSize.x, styledText.getLineHeight());
        caret.setFont(styledText.getFont());
        gc.dispose();
        return caret;
    }

    private void disposeNonDefaultCaret() {
        if (this.fNonDefaultCaretImage != null) {
            this.fNonDefaultCaretImage.dispose();
            this.fNonDefaultCaretImage = null;
        }
        if (this.fNonDefaultCaret != null) {
            this.fNonDefaultCaret.dispose();
            this.fNonDefaultCaret = null;
        }
    }

    private void dispose() {
        this.fPreferenceStore.removePropertyChangeListener(this.fPreferencePropertyListener);
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyListener);
        this.disposeNonDefaultCaret();
        this.fInitialCaret = null;
    }

    private class ToggleOverwriteHandler
    extends AbstractHandler {
        private ToggleOverwriteHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            TextViewerCustomCaretSupport.this.toggleOverwriteMode();
            return null;
        }
    }
}

