/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class GridStyleParameterObject {
    public Font tableFont;
    public Color evenRowColor;
    public Color oddRowColor;
    public Color selectionColor;
    public IStyle evenRowStyle;
    public IStyle oddRowStyle;
    public IStyle selectionStyle;
    public IStyle tableStyle;
    private final IConfigRegistry configRegistry;

    public GridStyleParameterObject(IConfigRegistry configRegistry) {
        this.configRegistry = configRegistry;
        this.init(configRegistry);
    }

    private void init(IConfigRegistry configRegistry) {
        this.evenRowStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "EVEN_BODY");
        this.evenRowColor = this.evenRowStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        this.oddRowStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "ODD_BODY");
        this.oddRowColor = this.oddRowStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        this.selectionStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, new String[0]);
        this.selectionColor = this.selectionStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        this.tableStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, new String[0]);
        this.tableFont = this.tableStyle.getAttributeValue(CellStyleAttributes.FONT);
    }

    public IConfigRegistry getConfigRegistry() {
        return this.configRegistry;
    }
}

