/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.sort.ISortModel;
import org.eclipse.statet.ecommons.waltable.sort.SortColumnEvent;
import org.eclipse.statet.ecommons.waltable.sort.SortDimPositionCommand;
import org.eclipse.statet.ecommons.waltable.sort.SortDirection;
import org.eclipse.swt.custom.BusyIndicator;

public class SortPositionCommandHandler
extends AbstractLayerCommandHandler<SortDimPositionCommand> {
    private final ISortModel sortModel;

    public SortPositionCommandHandler(ISortModel sortModel) {
        this.sortModel = sortModel;
    }

    @Override
    public Class<SortDimPositionCommand> getCommandClass() {
        return SortDimPositionCommand.class;
    }

    @Override
    protected boolean doCommand(final SortDimPositionCommand command) {
        final long columnId = command.getDim().getPositionId(command.getPosition(), command.getPosition());
        Runnable sortRunner = new Runnable(){

            @Override
            public void run() {
                ILayerDim dim = command.getDim();
                SortDirection newSortDirection = command.getDirection() != null ? command.getDirection() : SortPositionCommandHandler.this.sortModel.getSortDirection(columnId).getNextSortDirection();
                SortPositionCommandHandler.this.sortModel.sort(columnId, newSortDirection, command.isAccumulate());
                SortColumnEvent sortEvent = new SortColumnEvent(dim, command.getPosition());
                dim.getLayer().fireLayerEvent(sortEvent);
            }
        };
        BusyIndicator.showWhile(null, (Runnable)sortRunner);
        return true;
    }
}

