/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.ImagePainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class ColumnHeaderCheckBoxPainter
extends ImagePainter {
    private final Image checkedImg;
    private final Image semicheckedImg;
    private final Image uncheckedImg;
    private final ILayer columnDataLayer;

    public ColumnHeaderCheckBoxPainter(ILayer columnDataLayer) {
        this(columnDataLayer, GUIHelper.getImage("checked"), GUIHelper.getImage("semichecked"), GUIHelper.getImage("unchecked"));
    }

    public ColumnHeaderCheckBoxPainter(ILayer columnLayer, Image checkedImg, Image semicheckedImage, Image uncheckedImg) {
        this.columnDataLayer = columnLayer;
        this.checkedImg = checkedImg;
        this.semicheckedImg = semicheckedImage;
        this.uncheckedImg = uncheckedImg;
    }

    public long getPreferredWidth(boolean checked) {
        return checked ? this.checkedImg.getBounds().width : this.uncheckedImg.getBounds().width;
    }

    public long getPreferredHeight(boolean checked) {
        return checked ? this.checkedImg.getBounds().height : this.uncheckedImg.getBounds().height;
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        long columnPosition = LayerUtil.convertColumnPosition(cell.getLayer(), cell.getColumnPosition(), this.columnDataLayer);
        long checkedCellsCount = this.getCheckedCellsCount(columnPosition, configRegistry);
        if (checkedCellsCount > 0L) {
            if (checkedCellsCount == this.columnDataLayer.getRowCount()) {
                return this.checkedImg;
            }
            return this.semicheckedImg;
        }
        return this.uncheckedImg;
    }

    public long getCheckedCellsCount(long columnPosition, IConfigRegistry configRegistry) {
        long checkedCellsCount = 0L;
        long rowPosition = 0L;
        while (rowPosition < this.columnDataLayer.getRowCount()) {
            ILayerCell columnCell = this.columnDataLayer.getCellByPosition(columnPosition, rowPosition);
            if (this.isChecked(columnCell, configRegistry)) {
                ++checkedCellsCount;
            }
            ++rowPosition;
        }
        return checkedCellsCount;
    }

    protected boolean isChecked(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.convertDataType(cell, configRegistry);
    }

    protected Boolean convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
        if (cell.getDataValue(0, null) instanceof Boolean) {
            return (Boolean)cell.getDataValue(0, null);
        }
        IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        Boolean convertedValue = null;
        if (displayConverter != null) {
            try {
                convertedValue = (Boolean)displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue(0, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (convertedValue == null) {
            convertedValue = Boolean.FALSE;
        }
        return convertedValue;
    }
}

