/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.runtime.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.AppEnvironment;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.Status;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public final class RuntimeCorePlugin
extends Plugin
implements AppEnvironment {
    public static final String BUNDLE_ID = "org.eclipse.statet.ecommons.runtime.core";
    private static @Nullable RuntimeCorePlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();

    public static @Nullable RuntimeCorePlugin getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        RuntimeCorePlugin runtimeCorePlugin = this;
        synchronized (runtimeCorePlugin) {
            this.started = true;
        }
        CommonsRuntime.init((AppEnvironment)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        RuntimeCorePlugin runtimeCorePlugin = this;
        synchronized (runtimeCorePlugin) {
            this.started = false;
        }
        try {
            for (Disposable listener : this.disposables) {
                listener.dispose();
            }
        }
        finally {
            this.disposables.clear();
            instance = null;
            super.stop(context);
        }
    }

    public String getBundleId() {
        return BUNDLE_ID;
    }

    public void log(Status status) {
        this.getLog().log(StatusUtils.convert(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        ObjectUtils.nonNullAssert((Object)listener);
        RuntimeCorePlugin runtimeCorePlugin = this;
        synchronized (runtimeCorePlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStoppingListener(Disposable listener) {
        RuntimeCorePlugin runtimeCorePlugin = this;
        synchronized (runtimeCorePlugin) {
            if (!this.started) {
                return;
            }
            this.disposables.remove(listener);
        }
    }
}

