/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.docmlet.wikitext.core.source.WikitextDocumentConstants;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.jcommons.text.core.TextRegion;

public class MarkupDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    private final String partitioning;
    private final PartitionConstraint partitionConstrait;

    public MarkupDoubleClickStrategy(String partitioning) {
        if (partitioning == null) {
            throw new NullPointerException("partitioning");
        }
        this.partitioning = partitioning;
        this.partitionConstrait = WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT;
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        try {
            TreePartitionNode treeNode;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.partitioning, (int)offset, (boolean)false);
            if (partition instanceof TreePartition && this.partitionConstrait.matches(partition.getType()) && offset == (treeNode = ((TreePartition)partition).getTreeNode()).getStartOffset()) {
                return JFaceTextRegion.toJFaceRegion((TextRegion)treeNode);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }
}

