/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;

public class MarkupEventPrinter
extends DocumentBuilder {
    private final Writer out;
    private int depth;
    private MarkupLanguage markupLanguage;
    private String text;

    public MarkupEventPrinter(Writer out) {
        this.out = out;
    }

    public MarkupEventPrinter(String text, MarkupLanguage markupLanguage, Writer out) {
        this.out = out;
        this.reset(text, markupLanguage);
    }

    public void reset(String text, MarkupLanguage markupLanguage) {
        this.text = text;
        this.markupLanguage = markupLanguage;
    }

    protected void printIndent(int depth) throws IOException {
        int i = 0;
        while (i < depth) {
            this.out.write("    ");
            ++i;
        }
    }

    protected void header() {
        try {
            this.out.append("==== Document Events (");
            if (this.markupLanguage != null) {
                this.out.append("language= ");
                this.out.append(this.markupLanguage.getName());
                this.out.append(", ");
            }
            this.out.append("textLength= ");
            this.out.append(Integer.toString(this.text.length()));
            this.out.append(") ====\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void footer() {
        try {
            this.out.append("====\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void printBegin(int beginOffset) throws IOException {
        if (beginOffset < 0 || beginOffset > this.text.length()) {
            this.out.append("<out-of-range>");
            return;
        }
        this.out.append(this.text.substring(beginOffset, Math.min(beginOffset + 8, this.text.length())));
        this.out.append(" ...");
    }

    protected void printEnd(int endOffset) throws IOException {
        if (endOffset < 0 || endOffset > this.text.length()) {
            this.out.append("<out-of-range>");
            return;
        }
        this.out.append("... ");
        this.writeEncoded(this.text, Math.max(endOffset - 8, 0), endOffset);
    }

    private void writeEncoded(String s, int begin, int end) throws IOException {
        int i = begin;
        while (i < end) {
            char c = s.charAt(i);
            if (c < '\u0010') {
                this.out.write("<0x0");
                this.out.write(Integer.toHexString(c));
                this.out.write(62);
            } else if (c < ' ') {
                this.out.write("<0x");
                this.out.write(Integer.toHexString(c));
                this.out.write(62);
            } else {
                this.out.write(c);
            }
            ++i;
        }
    }

    private void begin(String label) {
        try {
            try {
                this.printIndent(this.depth);
                int beginOffset = this.locator.getDocumentOffset();
                int endOffset = this.locator.getLineDocumentOffset() + this.locator.getLineSegmentEndOffset();
                this.out.append("[");
                this.out.append(Integer.toString(beginOffset));
                this.out.append(", ");
                this.out.append(Integer.toString(endOffset));
                this.out.append(") ");
                this.out.append("begin");
                this.out.append(label);
                this.out.append(": ");
                this.printBegin(beginOffset);
                this.out.append('\n');
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            ++this.depth;
        }
    }

    private void end(String label) {
        try {
            --this.depth;
            this.printIndent(this.depth);
            int beginOffset = this.locator.getDocumentOffset();
            int endOffset = this.locator.getLineDocumentOffset() + this.locator.getLineSegmentEndOffset();
            this.out.append("[");
            this.out.append(Integer.toString(beginOffset));
            this.out.append(", ");
            this.out.append(Integer.toString(endOffset));
            this.out.append(") ");
            this.out.append("end");
            this.out.append(label);
            this.out.append(": ");
            this.printEnd(endOffset);
            this.out.append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void terminal(String label) {
        try {
            this.printIndent(this.depth);
            int beginOffset = this.locator.getDocumentOffset();
            int endOffset = this.locator.getLineDocumentOffset() + this.locator.getLineSegmentEndOffset();
            this.out.append("[");
            this.out.append(Integer.toString(beginOffset));
            this.out.append(", ");
            this.out.append(Integer.toString(endOffset));
            this.out.append(") ");
            this.out.append(label);
            this.out.append(": ");
            this.out.append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void beginDocument() {
        this.header();
        this.begin("Document");
    }

    public void endDocument() {
        this.end("Document");
        this.footer();
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        this.begin("Block(" + type + ")");
    }

    public void endBlock() {
        this.end("Block");
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.begin("Span(" + type + ")");
    }

    public void endSpan() {
        this.end("Span");
    }

    public void beginHeading(int level, Attributes attributes) {
        this.begin("Heading");
    }

    public void endHeading() {
        this.end("Heading");
    }

    public void characters(String text) {
        this.terminal("characters");
    }

    public void entityReference(String entity) {
        this.terminal("entityReference");
    }

    public void image(Attributes attributes, String url) {
        this.terminal("image");
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.terminal("link");
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.terminal("imageLink");
    }

    public void acronym(String text, String definition) {
        this.terminal("acronym");
    }

    public void lineBreak() {
        this.terminal("lineBreak");
    }

    public void charactersUnescaped(String literal) {
        this.terminal("charactersUnescaped");
    }
}

