/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.sourcemodel.IBuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceElements;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.RElementName;

public abstract class RChunkBuildElement
implements IBuildSourceFrameElement {
    protected final ISourceStructElement parent;
    protected final AstNode node;
    protected final RElementName name;
    protected final TextRegion nameRegion;
    int occurrenceCount;
    BuildSourceFrame envir;
    List<? extends IRLangSourceElement> sourceChildrenProtected = RSourceElements.NO_R_SOURCE_CHILDREN;

    public RChunkBuildElement(ISourceStructElement parent, AstNode node, RElementName name, TextRegion nameRegion) {
        this.parent = parent;
        this.node = node;
        this.name = name;
        this.nameRegion = nameRegion;
    }

    @Override
    public void setSourceChildren(List<? extends IRLangSourceElement> children) {
        this.sourceChildrenProtected = children;
    }

    @Override
    public BuildSourceFrame getBuildFrame() {
        return this.envir;
    }

    @Override
    public IRElement getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return false;
    }

    @Override
    public List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
        return null;
    }

    public ISourceStructElement getSourceParent() {
        return this.parent;
    }

    @Override
    public boolean hasSourceChildren(IModelElement.Filter filter) {
        return RSourceElements.hasChildren(this.sourceChildrenProtected, filter);
    }

    @Override
    public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
        return RSourceElements.getChildren(this.sourceChildrenProtected, filter);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == IRFrame.class) {
            return (T)this.envir;
        }
        if (adapterType == AstNode.class) {
            return (T)this.node;
        }
        return null;
    }

    public int hashCode() {
        return 640 * this.name.getSegmentName().hashCode() + this.occurrenceCount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RChunkBuildElement) {
            RChunkBuildElement other = (RChunkBuildElement)obj;
            if (this.occurrenceCount == other.occurrenceCount && this.name.equals(other.name)) {
                return true;
            }
        }
        return false;
    }
}

