/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.observable;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;

public abstract class ComputedOnChangeValue<TValue>
extends AbstractObservableValue<TValue>
implements IChangeListener {
    private final Object valueType;
    private final ImList<IObservable> dependencies;
    private boolean setting;
    private TValue value;

    public ComputedOnChangeValue(Object valueType, IObservable ... dependencies) {
        super(dependencies[0].getRealm());
        this.valueType = valueType;
        this.dependencies = ImCollections.newList((Object[])dependencies);
        IObservable[] iObservableArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable obs = iObservableArray[n2];
            obs.addChangeListener((IChangeListener)this);
            ++n2;
        }
    }

    public synchronized void dispose() {
        for (IObservable obs : this.dependencies) {
            obs.removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    public void handleChange(ChangeEvent event) {
        if (!this.setting) {
            TValue newValue = this.calculate();
            TValue oldValue = this.value;
            if (oldValue != null ? !oldValue.equals(newValue) : newValue != null) {
                this.value = newValue;
                this.fireValueChange(Diffs.createValueDiff(oldValue, this.value));
            }
        }
    }

    public Object getValueType() {
        return this.valueType;
    }

    protected final TValue doGetValue() {
        return this.calculate();
    }

    protected final void doSetValue(TValue value) {
        this.setting = true;
        try {
            this.extractAndSet(value);
            this.value = value;
        }
        finally {
            this.setting = false;
        }
    }

    protected abstract TValue calculate();

    protected void extractAndSet(Object value) {
        throw new UnsupportedOperationException();
    }
}

