/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.text.ui.DefaultBrowserInformationInput;
import org.eclipse.statet.ecommons.text.ui.PositionBasedCompletionProposal;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.templates.IWorkbenchTemplateContext;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class TemplateProposal
implements IAssistCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private final Template template;
    private final TemplateContext context;
    private final int relevance;
    private final @Nullable Image image;
    private TextRegion region;
    private TextRegion selectionToSet;
    private @Nullable InclusivePositionUpdater updater;

    public TemplateProposal(Template template, TemplateContext context, TextRegion region, @Nullable Image image, int relevance) {
        assert (template != null);
        assert (context != null);
        assert (region != null);
        this.template = template;
        this.context = context;
        this.image = image;
        this.region = region;
        this.relevance = relevance;
    }

    public void selected(ITextViewer textViewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer textViewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                return this.template.getName().regionMatches(true, 0, content, 0, content.length());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    protected TemplateContext getContext() {
        return this.context;
    }

    protected Template getTemplate() {
        return this.template;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public char[] getTriggerCharacters() {
        return new char[0];
    }

    @Override
    public int getRelevance() {
        return this.relevance;
    }

    @Override
    public String getSortingString() {
        return this.template.getName();
    }

    public boolean isAutoInsertable() {
        return this.template.isAutoInsertable();
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    public StyledString getStyledDisplayString() {
        StyledString s = new StyledString(this.template.getName());
        if (!this.template.getDescription().isEmpty()) {
            s.append("\u2002\u2013\u2002", StyledString.QUALIFIER_STYLER);
            s.append(this.template.getDescription(), StyledString.QUALIFIER_STYLER);
        }
        return s;
    }

    public @Nullable Image getImage() {
        return this.image;
    }

    public @Nullable IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public @Nullable String getAdditionalProposalInfo() {
        return null;
    }

    public @Nullable Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        try {
            TemplateContext context = this.getContext();
            context.setReadOnly(true);
            if (context instanceof IWorkbenchTemplateContext) {
                return new DefaultBrowserInformationInput(null, this.getDisplayString(), ((IWorkbenchTemplateContext)context).evaluateInfo(this.getTemplate()), 3);
            }
            TemplateBuffer templateBuffer = context.evaluate(this.getTemplate());
            if (templateBuffer != null) {
                return new DefaultBrowserInformationInput(null, this.getDisplayString(), templateBuffer.toString(), 3);
            }
        }
        catch (TemplateException templateException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public void apply(IDocument document) {
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        block18: {
            IDocument document = viewer.getDocument();
            Position regionPosition = new Position(this.region.getStartOffset(), this.region.getLength());
            Position offsetPosition = new Position(offset, 0);
            try {
                TemplateBuffer templateBuffer;
                document.addPosition(regionPosition);
                document.addPosition(offsetPosition);
                this.context.setReadOnly(false);
                try {
                    templateBuffer = this.context.evaluate(this.template);
                }
                catch (TemplateException e1) {
                    this.selectionToSet = new BasicTextRegion(this.region);
                    document.removePosition(regionPosition);
                    document.removePosition(offsetPosition);
                    return;
                }
                try {
                    this.region = LTKSelectionUtils.toTextRegion(regionPosition);
                    int start = this.getReplaceOffset();
                    int end = Math.max(this.getReplaceEndOffset(), offsetPosition.getOffset());
                    String templateString = templateBuffer.getString();
                    document.replace(start, end - start, templateString);
                    LinkedModeModel model = new LinkedModeModel();
                    TemplateVariable[] variables = templateBuffer.getVariables();
                    boolean hasPositions = false;
                    int i = 0;
                    while (i != variables.length) {
                        TemplateVariable variable = variables[i];
                        if (!variable.isUnambiguous()) {
                            LinkedPositionGroup group = new LinkedPositionGroup();
                            int[] offsets = variable.getOffsets();
                            int length = variable.getLength();
                            String[] values = variable.getValues();
                            ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                            int j = 0;
                            while (j < values.length) {
                                this.ensurePositionCategoryInstalled(document, model);
                                Position pos = new Position(offsets[0] + start, length);
                                document.addPosition(this.getCategory(), pos);
                                proposals[j] = new PositionBasedCompletionProposal(values[j], pos, length);
                                ++j;
                            }
                            j = 0;
                            while (j < offsets.length) {
                                if (j == 0 && proposals.length > 1) {
                                    group.addPosition((LinkedPosition)new ProposalPosition(document, offsets[j] + start, length, proposals));
                                } else {
                                    group.addPosition(new LinkedPosition(document, offsets[j] + start, length));
                                }
                                ++j;
                            }
                            model.addGroup(group);
                            hasPositions = true;
                        }
                        ++i;
                    }
                    if (hasPositions) {
                        ISourceEditor editor;
                        model.forceInstall();
                        if (this.context instanceof IWorkbenchTemplateContext && (editor = ((IWorkbenchTemplateContext)this.context).getEditor()).getTextEditToolSynchronizer() != null) {
                            editor.getTextEditToolSynchronizer().install(model);
                        }
                        LinkedModeUI ui = new LinkedModeUI(model, viewer);
                        ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                        ui.enter();
                        this.selectionToSet = LTKSelectionUtils.toTextRegion(ui.getSelectedRegion());
                        break block18;
                    }
                    this.ensurePositionCategoryRemoved(document);
                    this.selectionToSet = new BasicTextRegion(this.getCaretOffset(templateBuffer) + start);
                }
                catch (BadLocationException e) {
                    this.handleError((Exception)((Object)e));
                }
                catch (BadPositionCategoryException e) {
                    this.handleError((Exception)((Object)e));
                }
            }
            finally {
                document.removePosition(regionPosition);
                document.removePosition(offsetPosition);
            }
        }
    }

    private void handleError(Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", 0, "Template Evaluation Error", (Throwable)e));
        this.selectionToSet = this.region;
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.updater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.updater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    TemplateProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater((IPositionUpdater)this.updater);
        }
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    protected final int getReplaceOffset() {
        int start;
        if (this.context instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.context;
            start = docContext.getStart();
        } else {
            start = this.region.getStartOffset();
        }
        return start;
    }

    protected final int getReplaceEndOffset() {
        int end;
        if (this.context instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.context;
            end = docContext.getEnd();
        } else {
            end = this.region.getEndOffset();
        }
        return end;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.template.getName();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplaceOffset();
    }

    public @Nullable Point getSelection(@Nullable IDocument document) {
        if (this.selectionToSet != null) {
            return new Point(this.selectionToSet.getStartOffset(), this.selectionToSet.getLength());
        }
        return null;
    }

    public int getContextInformationPosition() {
        return this.region.getStartOffset();
    }

    public @Nullable IContextInformation getContextInformation() {
        return null;
    }

    public static class TemplateComparator
    implements Comparator<TemplateProposal> {
        private final Collator collator = Collator.getInstance();

        @Override
        public int compare(TemplateProposal arg0, TemplateProposal arg1) {
            int result = this.collator.compare(arg0.getTemplate().getName(), arg1.getTemplate().getName());
            if (result != 0) {
                return result;
            }
            return this.collator.compare(arg0.getDisplayString(), arg1.getDisplayString());
        }
    }
}

