/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.text.ui.DefaultBrowserInformationInput;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.ltk.ui.sourceediting.ICommandAccess;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class CommandAssistProposal
implements IAssistCompletionProposal,
ICommandAccess,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private final AssistInvocationContext context;
    private final String commandId;
    private String label;
    private String description;
    private int relevance;

    public static StyledString addAcceleratorStyled(String message, KeySequence binding) {
        StyledString styledString = new StyledString(message);
        if (binding != null) {
            styledString.append(" (", StyledString.QUALIFIER_STYLER);
            styledString.append(binding.format(), StyledString.QUALIFIER_STYLER);
            styledString.append(')', StyledString.QUALIFIER_STYLER);
        }
        return styledString;
    }

    public CommandAssistProposal(AssistInvocationContext invocationContext, String commandId) {
        this.context = invocationContext;
        this.commandId = commandId;
    }

    public CommandAssistProposal(AssistInvocationContext invocationContext, String commandId, String label, String description) {
        this(invocationContext, commandId);
        this.label = label;
        this.description = description;
    }

    @Override
    public final String getCommandId() {
        return this.commandId;
    }

    protected AssistInvocationContext getInvocationContext() {
        return this.context;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setRelevance(int relevance) {
        this.relevance = relevance;
    }

    public void selected(ITextViewer textViewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer textViewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    public void apply(IDocument document) {
        throw new UnsupportedOperationException();
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    @Override
    public int getRelevance() {
        return this.relevance;
    }

    @Override
    public String getSortingString() {
        return this.label;
    }

    public String getDisplayString() {
        return this.label;
    }

    public StyledString getStyledDisplayString() {
        return CommandAssistProposal.addAcceleratorStyled(this.getDisplayString(), WorkbenchUIUtils.getBestKeyBinding((String)this.commandId));
    }

    public Image getImage() {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.description;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return new DefaultBrowserInformationInput(null, this.getDisplayString(), this.description, 2);
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

