/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.preferences;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.components.DataAdapter;
import org.eclipse.statet.ecommons.ui.components.DropDownButton;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.debug.ui.preferences.LocalREnvConfigDialog;
import org.eclipse.statet.internal.r.debug.ui.preferences.Messages;
import org.eclipse.statet.internal.r.debug.ui.preferences.REnvLabelProvider;
import org.eclipse.statet.internal.r.debug.ui.preferences.RemoteREnvConfigDialog;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCorePreferenceNodes;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.core.renv.IREnvManager;
import org.eclipse.statet.r.launching.RRunDebugPreferenceConstants;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.statushandlers.StatusManager;

class REnvConfigurationBlock
extends ManagedConfigurationBlock
implements ButtonGroup.IActions<IREnvConfiguration.WorkingCopy> {
    private static final int ADD_NEW_DEFAULT = 1;
    private static final int ADD_NEW_REMOTE = 257;
    private TableViewer listViewer;
    private ButtonGroup<IREnvConfiguration.WorkingCopy> listButtons;
    private final IObservableList<IREnvConfiguration> envList = new WritableList();
    private final IObservableValue<IREnvConfiguration> envDefault = new WritableValue();
    private final IObservableValue<IStatus> envListStatus = new WritableValue();
    private ComboViewer indexConsoleViewer;
    private Button networkEclipseControl;

    @NonNullByDefault
    private static String trimUri(String s) {
        try {
            URI uri = new URI(s);
            URI uiUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            return uiUri.toString();
        }
        catch (URISyntaxException e) {
            return s;
        }
    }

    protected REnvConfigurationBlock(IProject project, StatusChangeListener statusListener) {
        super(project, statusListener);
    }

    protected String getHelpContext() {
        return "org.eclipse.statet.r.ui.r_env";
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Preference.StringPref, Object> prefs = new HashMap<Preference.StringPref, Object>();
        prefs.put(RRunDebugPreferenceConstants.PREF_RENV_CHECK_UPDATE, null);
        this.setupPreferenceManager(prefs);
        Label label = new Label(pageComposite, 16384);
        label.setText(Messages.REnv_REnvList_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Composite table = this.createTable(composite);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((Table)this.listViewer.getTable(), (int)12, (boolean)false);
        table.setLayoutData((Object)gd);
        this.listButtons = new ButtonGroup(composite, (ButtonGroup.IActions)this, false);
        this.listButtons.setLayoutData((Object)new GridData(4, 128, false, true));
        SelectionAdapter addDefaultListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                REnvConfigurationBlock.this.listButtons.editElement(1, null);
            }
        };
        DropDownButton addButton = new DropDownButton(this.listButtons);
        Menu addMenu = addButton.getDropDownMenu();
        MenuItem menuItem = new MenuItem(addMenu, 8);
        menuItem.setText(Messages.REnv_Add_Local_label);
        menuItem.addSelectionListener((SelectionListener)addDefaultListener);
        menuItem = new MenuItem(addMenu, 8);
        menuItem.setText(Messages.REnv_Add_Remote_label);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                REnvConfigurationBlock.this.listButtons.editElement(257, null);
            }
        });
        addButton.addSelectionListener((SelectionListener)addDefaultListener);
        addButton.setText(String.valueOf(SharedMessages.CollectionEditing_AddItem_label) + "...");
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.listButtons.addCopyButton(null);
        this.listButtons.addEditButton(null);
        this.listButtons.addDeleteButton(null);
        this.listButtons.addSeparator();
        this.listButtons.addDefaultButton(null);
        this.listButtons.connectTo((StructuredViewer)this.listViewer, (DataAdapter)new DataAdapter.ListAdapter<IREnvConfiguration.WorkingCopy>(this.envList, this.envDefault){

            public boolean isDeleteAllowed(Object element) {
                IREnvConfiguration config = (IREnvConfiguration)element;
                return config.isEditable();
            }
        });
        this.listViewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                if (element instanceof IREnvConfiguration) {
                    return ((IREnvConfiguration)element).getREnv().hashCode();
                }
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (a instanceof IREnvConfiguration && b instanceof IREnvConfiguration) {
                    return ((IREnvConfiguration)a).getREnv().equals((Object)((IREnvConfiguration)b).getREnv());
                }
                return a.equals(b);
            }
        });
        this.listViewer.setInput(this.envList);
        ViewerUtils.scheduleStandardSelection((TableViewer)this.listViewer);
        this.loadValues(PreferenceUtils.getInstancePrefs());
        Composite indexOptions = this.createIndexOptions(pageComposite);
        indexOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite networkOptions = this.createNetworkOptions(pageComposite);
        networkOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        this.initBindings();
        this.updateStatus();
        final DataBindingContext dbc = this.getDataBinding().getContext();
        dbc.addValidationStatusProvider(new ValidationStatusProvider(){

            public IObservableValue<IStatus> getValidationStatus() {
                return REnvConfigurationBlock.this.envListStatus;
            }

            public IObservableList<IObservable> getModels() {
                return Observables.staticObservableList((Realm)dbc.getValidationRealm(), Collections.emptyList());
            }

            public IObservableList<IObservable> getTargets() {
                return Observables.staticObservableList((Realm)dbc.getValidationRealm(), Collections.emptyList());
            }
        });
        this.updateControls();
        this.listButtons.refresh();
    }

    public IREnvConfiguration.WorkingCopy edit(int command, IREnvConfiguration.WorkingCopy config, Object parent) {
        IREnvConfiguration.WorkingCopy editConfig;
        boolean newConfig;
        boolean bl = newConfig = (command & 3) != 0;
        if (newConfig) {
            if (config != null) {
                editConfig = RCore.getREnvManager().newConfiguration(config.getType());
                editConfig.load((IREnvConfiguration)config);
            } else {
                editConfig = command == 257 ? RCore.getREnvManager().newConfiguration("user-remote") : RCore.getREnvManager().newConfiguration("user-local");
            }
        } else {
            editConfig = config.createWorkingCopy();
        }
        if (this.doEdit(editConfig, newConfig)) {
            if (newConfig) {
                return editConfig;
            }
            config.load((IREnvConfiguration)editConfig);
            return config;
        }
        return null;
    }

    private boolean doEdit(IREnvConfiguration.WorkingCopy config, boolean newConfig) {
        ExtStatusDialog dialog;
        ArrayList<IREnvConfiguration> existingConfigs = new ArrayList<IREnvConfiguration>((Collection<IREnvConfiguration>)this.envList);
        if (!newConfig) {
            Iterator iter = existingConfigs.iterator();
            while (iter.hasNext()) {
                IREnvConfiguration existing = (IREnvConfiguration)iter.next();
                if (existing.getREnv() != config.getREnv()) continue;
                iter.remove();
                break;
            }
        }
        if (config.isLocal()) {
            dialog = new LocalREnvConfigDialog(this.getShell(), config, newConfig, existingConfigs);
        } else if (config.isRemote()) {
            dialog = new RemoteREnvConfigDialog(this.getShell(), config, newConfig, existingConfigs);
        } else {
            return false;
        }
        return dialog.open() == 0;
    }

    public void updateState(IStructuredSelection selection) {
        this.updateStatus();
    }

    private Composite createTable(Composite parent) {
        ViewerUtils.TableComposite composite = new ViewerUtils.TableComposite(parent, 68098);
        this.listViewer = composite.viewer;
        composite.table.setHeaderVisible(true);
        composite.table.setLinesVisible(true);
        TableViewerColumn column = new TableViewerColumn(composite.viewer, 0);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.getColumn().setText(Messages.REnv_NameColumn_name);
        column.setLabelProvider((CellLabelProvider)new REnvLabelProvider(this.envDefault));
        column = new TableViewerColumn(composite.viewer, 0);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.getColumn().setText(Messages.REnv_LocationColumn_name);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IREnvConfiguration config = (IREnvConfiguration)element;
                if (config.getType() == "user-local") {
                    return (String)ObjectUtils.nonNullElse((Object)config.getRHomeDirectory(), (Object)"");
                }
                if (config.getType() == "eplugin-local") {
                    return "<supplied>";
                }
                if (config.getType() == "user-remote") {
                    String server = config.getStateSharedServer();
                    return server != null ? REnvConfigurationBlock.trimUri(server) : "";
                }
                return "";
            }
        });
        composite.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        composite.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return this.getComparator().compare(((IREnvConfiguration)e1).getName(), ((IREnvConfiguration)e2).getName());
            }
        });
        return composite;
    }

    private Composite createIndexOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        composite.setText(Messages.REnv_Index_label);
        Label label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText(Messages.REnv_Update_Console_label);
        this.indexConsoleViewer = new ComboViewer((Composite)composite, 12);
        this.indexConsoleViewer.getControl().setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.indexConsoleViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element.equals("auto")) {
                    return Messages.REnv_Update_Console_Auto_label;
                }
                if (element.equals("ask")) {
                    return Messages.REnv_Update_Console_Ask_label;
                }
                if (element.equals("no")) {
                    return Messages.REnv_Update_Console_Disabled_label;
                }
                return "";
            }
        });
        this.indexConsoleViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.indexConsoleViewer.setInput((Object)new String[]{"auto", "ask", "no"});
        return composite;
    }

    private Composite createNetworkOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        composite.setText(Messages.REnv_Network_label);
        Composite line = new Composite((Composite)composite, 0);
        line.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout layout = LayoutUtils.newCompositeGrid((int)2);
        layout.horizontalSpacing = 0;
        line.setLayout((Layout)layout);
        this.networkEclipseControl = new Button(line, 32);
        int idx = Messages.REnv_Network_UseEclipse_label.indexOf("<a");
        this.networkEclipseControl.setText(Messages.REnv_Network_UseEclipse_label.substring(0, idx).trim());
        this.networkEclipseControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Link link = this.addLinkControl(line, Messages.REnv_Network_UseEclipse_label.substring(idx));
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.indexConsoleViewer), this.createObservable((Preference)RRunDebugPreferenceConstants.PREF_RENV_CHECK_UPDATE));
        db.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.networkEclipseControl), this.createObservable((Preference)RCorePreferenceNodes.PREF_RENV_NETWORK_USE_ECLIPSE));
    }

    public boolean performOk(int flags) {
        boolean ok = super.performOk(flags);
        if (this.listButtons.getDataAdapter().isDirty()) {
            ok &= this.saveValues((flags & 0x10) != 0);
        }
        return ok;
    }

    private void updateStatus() {
        this.envListStatus.setValue((Object)(this.envDefault.getValue() == null ? ValidationStatus.warning((String)Messages.REnv_warning_NoDefaultConfiguration_message) : ValidationStatus.ok()));
    }

    private boolean saveValues(boolean saveStore) {
        try {
            IREnvConfiguration defaultREnv = (IREnvConfiguration)this.envDefault.getValue();
            RCore.getREnvManager().set(ImCollections.toList(this.envList), defaultREnv != null ? defaultREnv.getREnv().getId() : null);
            return true;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, Messages.REnv_error_Saving_message, (Throwable)e), 3);
            return false;
        }
    }

    private void loadValues(PreferenceAccess prefs) {
        this.envList.clear();
        this.envDefault.setValue(null);
        IREnvManager manager = RCore.getREnvManager();
        REnv defaultEnv = manager.getDefault().resolve();
        List rEnvConfigs = manager.getConfigurations();
        for (IREnvConfiguration rEnvConfig : rEnvConfigs) {
            IREnvConfiguration.WorkingCopy config = rEnvConfig.createWorkingCopy();
            this.envList.add((Object)config);
            if (config.getREnv() != defaultEnv) continue;
            this.envDefault.setValue((Object)config);
        }
    }
}

