/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.nico.core.runtime.ConsoleRunnable;
import org.eclipse.statet.nico.core.runtime.IRequireSynch;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public class SubmitSelectionAndPasteOutputHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISourceEditor editor = (ISourceEditor)workbenchPart.getAdapter(ISourceEditor.class);
        if (editor != null) {
            if (!editor.isEditable(true)) {
                this.cancel(null, (IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", RLaunchingMessages.SubmitCodeAndPasteOutput_info_WriteProtected_status), event);
                return null;
            }
            R r = new R(editor);
            SourceViewer viewer = editor.getViewer();
            ITextSelection selection = (ITextSelection)viewer.getSelection();
            if (!r.setupSource(selection)) {
                this.cancel(r, (IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", RLaunchingMessages.SubmitCodeAndPasteOutput_error_Unspecific_status), null);
                return null;
            }
            ToolProcess process = NicoUI.getToolRegistry().getActiveToolSession(UIAccess.getActiveWorkbenchPage((boolean)true)).getProcess();
            try {
                NicoUITools.accessTool((String)"R", (Tool)process);
            }
            catch (CoreException e) {
                this.cancel(r, e.getStatus(), event);
                return null;
            }
            Status status = process.getQueue().add((ToolRunnable)r);
            if (status.getSeverity() >= 4) {
                this.cancel(r, StatusUtils.convert((Status)status), event);
            }
            return null;
        }
        LaunchShortcutUtil.handleUnsupportedExecution(event);
        return null;
    }

    private void cancel(R r, IStatus status, ExecutionEvent executionEvent) {
        if (r != null) {
            r.dispose();
        }
        LTKWorkbenchUIUtil.indicateStatus((IStatus)status, (ExecutionEvent)executionEvent);
    }

    private static class R
    implements ConsoleRunnable,
    Runnable {
        private ISourceEditor fEditor;
        private IDocument fDocument;
        private String[] fLines;
        private Position fPosition;
        private StringBuilder fOutput;

        R(ISourceEditor editor) {
            this.fEditor = editor;
        }

        private boolean setupSource(ITextSelection selection) {
            SourceViewer viewer = this.fEditor.getViewer();
            this.fDocument = viewer.getDocument();
            try {
                if (selection.getLength() > 0) {
                    ArrayList lines = new ArrayList(0);
                    TextUtil.addLines((IDocument)this.fDocument, (int)selection.getOffset(), (int)selection.getLength(), lines);
                    this.fLines = lines.toArray(new String[lines.size()]);
                    int start = selection.getOffset();
                    int end = start + selection.getLength();
                    char c = this.fDocument.getChar(end - 1);
                    if (c == '\n') {
                        if (--end > 0 && this.fDocument.getChar(end - 1) == '\r') {
                            --end;
                        }
                    } else if (c == '\r') {
                        --end;
                    }
                    this.fPosition = new Position(start, end - start);
                } else {
                    IRegion line = this.fDocument.getLineInformationOfOffset(selection.getOffset());
                    this.fLines = new String[]{this.fDocument.get(line.getOffset(), line.getLength())};
                    this.fPosition = new Position(line.getOffset(), line.getLength());
                }
                this.fDocument.addPosition(this.fPosition);
                return true;
            }
            catch (BadLocationException e) {
                StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", -1, "An error occurred preparing Run and Paste Output", (Throwable)e));
                return false;
            }
        }

        public void dispose() {
            if (this.fDocument != null && this.fPosition != null) {
                this.fDocument.removePosition(this.fPosition);
            }
            this.fEditor = null;
            this.fDocument = null;
            this.fPosition = null;
            this.fOutput = null;
            this.fLines = null;
        }

        public String getTypeId() {
            return "editor/run-and-paste";
        }

        public String getLabel() {
            return RLaunchingMessages.SubmitCodeAndPasteOutput_RTask_label;
        }

        public SubmitType getSubmitType() {
            return SubmitType.EDITOR;
        }

        public boolean canRunIn(Tool tool) {
            return tool.isProvidingFeatureSet("org.eclipse.statet.r.basic");
        }

        public boolean changed(int event, Tool process) {
            switch (event) {
                case 288: 
                case 290: {
                    UIAccess.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            this.dispose();
                        }
                    });
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            IRBasicAdapter r = (IRBasicAdapter)service;
            this.fOutput = new StringBuilder(200);
            IStreamListener listener = new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    fOutput.append(text);
                }
            };
            ToolController controller = r.getController();
            r.briefAboutToChange();
            try {
                Pattern pattern;
                controller.getStreams().getOutputStreamMonitor().addListener(listener);
                controller.getStreams().getErrorStreamMonitor().addListener(listener);
                int i = 0;
                while (i < this.fLines.length) {
                    if (m.isCanceled()) {
                        return;
                    }
                    m.beginSubTask(this.fLines[i]);
                    r.submitToConsole(this.fLines[i], m);
                    ++i;
                }
                if (r instanceof IRequireSynch && (pattern = ((IRequireSynch)r).synch(m)) != null) {
                    Matcher matcher = pattern.matcher(this.fOutput);
                    int idx = -1;
                    while (matcher.find()) {
                        idx = matcher.start();
                    }
                    if (idx >= 0) {
                        this.fOutput.delete(idx, this.fOutput.length());
                    }
                }
            }
            finally {
                r.briefChanged(1);
                controller.getStreams().getOutputStreamMonitor().removeListener(listener);
                controller.getStreams().getErrorStreamMonitor().removeListener(listener);
                UIAccess.getDisplay().asyncExec((Runnable)this);
            }
        }

        protected IRCoreAccess getRCoreAccess() {
            ISourceEditor editor = this.fEditor;
            return editor instanceof IRSourceEditor ? ((IRSourceEditor)editor).getRCoreAccess() : RCore.WORKBENCH_ACCESS;
        }

        @Override
        public void run() {
            IServiceLocator serviceLocator;
            SourceViewer viewer = this.fEditor.getViewer();
            if (!UIAccess.isOkToUse((Viewer)viewer) || viewer.getDocument() != this.fDocument || this.fPosition.isDeleted()) {
                return;
            }
            IWorkbenchSiteProgressService progressService = null;
            ISourceEditor editor = (ISourceEditor)this.fEditor.getAdapter(ISourceEditor.class);
            if (editor != null && (serviceLocator = editor.getServiceLocator()) != null) {
                progressService = (IWorkbenchSiteProgressService)serviceLocator.getService(IWorkbenchSiteProgressService.class);
            }
            if (progressService != null) {
                progressService.incrementBusy();
            }
            try {
                try {
                    IndentUtil util = new IndentUtil(this.fDocument, (IIndentSettings)this.getRCoreAccess().getRCodeStyle());
                    int indent = util.getMultilineIndentColumn(this.fDocument.getLineOfOffset(this.fPosition.getOffset()), this.fDocument.getLineOfOffset(this.fPosition.getOffset() + this.fPosition.getLength()));
                    String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument);
                    String prefix = String.valueOf(delimiter) + util.createIndentString(indent) + "# ";
                    String[] lines = RUtil.LINE_SEPARATOR_PATTERN.split(this.fOutput);
                    int size = this.fOutput.length() + lines.length * (prefix.length() - 1) + 2;
                    this.fOutput.setLength(0);
                    this.fOutput.ensureCapacity(size);
                    int i = 0;
                    while (i < lines.length) {
                        this.fOutput.append(prefix);
                        this.fOutput.append(lines[i]);
                        ++i;
                    }
                    this.fOutput.append(delimiter);
                    int pos = this.fPosition.getOffset() + this.fPosition.getLength();
                    this.fDocument.replace(pos, 0, this.fOutput.toString());
                    viewer.revealRange(pos, this.fOutput.length());
                    if (progressService != null) {
                        progressService.warnOfContentChange();
                    }
                }
                catch (BadLocationException e) {
                    StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", -1, RLaunchingMessages.SubmitCodeAndPasteOutput_error_WhenPasting_message, (Throwable)e), 3);
                    this.dispose();
                    if (progressService != null) {
                        progressService.decrementBusy();
                    }
                }
            }
            finally {
                this.dispose();
                if (progressService != null) {
                    progressService.decrementBusy();
                }
            }
        }
    }
}

