/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util.dataaccess;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class RDataSubset {
    private final long rowBeginIdx;
    private final long rowCount;
    private final long columnBeginIdx;
    private final long columnCount;

    public RDataSubset(long rowBeginIdx, long rowCount, long columnBeginIdx, long columnCount) {
        this.rowBeginIdx = rowBeginIdx;
        this.rowCount = rowCount;
        this.columnBeginIdx = columnBeginIdx;
        this.columnCount = columnCount;
    }

    public final long getRowBeginIdx() {
        return this.rowBeginIdx;
    }

    public final long getRowEndIdx() {
        return this.rowBeginIdx + this.rowCount;
    }

    public final long getRowCount() {
        return this.rowCount;
    }

    public long toLocalRowIdx(long rowIdx) {
        long idx;
        if (rowIdx < this.rowBeginIdx || (idx = rowIdx - this.rowBeginIdx) >= this.rowCount) {
            throw new IndexOutOfBoundsException(Long.toString(rowIdx));
        }
        return idx;
    }

    public final long getColumnBeginIdx() {
        return this.columnBeginIdx;
    }

    public final long getColumnEndIdx() {
        return this.columnBeginIdx + this.columnCount;
    }

    public final long getColumnCount() {
        return this.columnCount;
    }

    public long toLocalColumnIdx(long columnIdx) {
        long idx;
        if (columnIdx < this.columnBeginIdx || (idx = columnIdx - this.columnBeginIdx) >= this.columnCount) {
            throw new IndexOutOfBoundsException(Long.toString(columnIdx));
        }
        return idx;
    }

    public long getLength() {
        return this.rowCount * this.columnCount;
    }
}

