/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.wikitext.r.ui.codegen;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.redocs.wikitext.r.RedocsWikitextRPlugin;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.Messages;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.templates.NewDocTemplateGenerateWizardPage;
import org.eclipse.statet.ltk.ui.templates.TemplateUtils;
import org.eclipse.statet.ltk.ui.wizards.NewElementWizard;
import org.eclipse.statet.redocs.wikitext.r.ui.codegen.CodeGeneration;
import org.eclipse.statet.redocs.wikitext.r.ui.codegen.NewWikidocRweaveDocCreationWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class NewWikidocRweaveDocCreationWizard
extends NewElementWizard {
    private final IContentType contentType;
    private NewWikidocRweaveDocCreationWizardPage firstPage;
    private NewElementWizard.NewFile newDocFile;
    private NewDocTemplateGenerateWizardPage templatePage;

    public NewWikidocRweaveDocCreationWizard(IContentType contentType) {
        this.contentType = contentType;
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)RedocsWikitextRPlugin.getInstance(), (String)"NewElementWizard"));
        this.setDefaultPageImageDescriptor(RedocsWikitextRPlugin.getInstance().getImageRegistry().getDescriptor("org.eclipse.statet.redocs.wikitext.r/image/wizban/New-WikidocRweaveFile"));
    }

    public void addPages() {
        super.addPages();
        this.firstPage = this.createFirstPage(this.getSelection());
        this.addPage((IWizardPage)this.firstPage);
        this.templatePage = this.createTemplatePage();
        this.addPage((IWizardPage)this.templatePage);
    }

    protected abstract NewWikidocRweaveDocCreationWizardPage createFirstPage(IStructuredSelection var1);

    protected abstract NewDocTemplateGenerateWizardPage createTemplatePage();

    public void createPageControls(Composite pageContainer) {
        this.firstPage.createControl(pageContainer);
    }

    protected ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = this.createRule((IResource)this.newDocFile.getResource());
        if (rule != null) {
            return rule;
        }
        return super.getSchedulingRule();
    }

    public boolean performFinish() {
        this.newDocFile = new NewRweaveFile(this.firstPage.resourceGroup.getContainerFullPath(), this.firstPage.resourceGroup.getResourceName(), this.contentType, this.templatePage.getTemplate());
        boolean result = super.performFinish();
        IFile newFile = this.newDocFile.getResource();
        if (result && newFile != null) {
            this.selectAndReveal((IResource)newFile);
            this.openResource(this.newDocFile);
        }
        return result;
    }

    protected void performOperations(IProgressMonitor monitor) throws InterruptedException, CoreException, InvocationTargetException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewDocWizard_Task_label, (int)11);
        this.newDocFile.createFile((IProgressMonitor)m.newChild(10));
        m.worked(0);
        this.firstPage.saveSettings();
        m.worked(1);
    }

    private static class NewRweaveFile
    extends NewElementWizard.NewFile {
        private final Template template;

        public NewRweaveFile(IPath containerPath, String resourceName, IContentType contentType, Template template) {
            super(containerPath, resourceName, contentType);
            this.template = template;
        }

        protected String getInitialFileContent(IFile newFileHandle, SubMonitor m) {
            String lineDelimiter = TextUtil.getLineDelimiter((IProject)newFileHandle.getProject());
            ISourceUnit su = LTK.getSourceUnitManager().getSourceUnit(LTK.PERSISTENCE_CONTEXT, (Object)newFileHandle, this.getContentType(newFileHandle), true, (IProgressMonitor)m);
            try {
                TemplateUtils.EvaluatedTemplate data = CodeGeneration.getNewDocContent(su, lineDelimiter, this.template);
                if (data != null) {
                    this.initialSelection = data.getRegionToSelect();
                    String string = data.getContent();
                    return string;
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.redocs.wikitext.r", 0, Messages.NewDocWizard_error_ApplyTemplate_message, (Throwable)e));
            }
            finally {
                if (su != null) {
                    su.disconnect((IProgressMonitor)m);
                }
            }
            return null;
        }
    }
}

