/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.sourceediting;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupLanguageDocumentSetupParticipant;
import org.eclipse.statet.internal.redocs.wikitext.r.RedocsWikitextRPlugin;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateCompletionComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.redocs.r.ui.RedocsRUIResources;
import org.eclipse.statet.redocs.wikitext.r.core.source.IRweaveMarkupLanguage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.templates.ContextTypeRegistry;

public class RChunkTemplateCompletionComputer
extends TemplateCompletionComputer {
    private IRweaveMarkupLanguage markupLanguage;

    public RChunkTemplateCompletionComputer() {
        super(RedocsWikitextRPlugin.getInstance().getCodegenTemplateStore(), (ContextTypeRegistry)RedocsWikitextRPlugin.getInstance().getCodegenTemplateContextTypeRegistry());
    }

    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
        IMarkupLanguage markupLanguage = MarkupLanguageDocumentSetupParticipant.getMarkupLanguage((IDocument)editor.getViewer().getDocument(), (String)editor.getDocumentContentInfo().getPartitioning());
        if (markupLanguage instanceof IRweaveMarkupLanguage) {
            this.markupLanguage = (IRweaveMarkupLanguage)markupLanguage;
        }
    }

    public void sessionEnded() {
        this.markupLanguage = null;
    }

    public IStatus computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (mode == 1) {
            mode = 2;
        }
        this.sessionStarted(context.getEditor(), null);
        try {
            if (this.markupLanguage == null) {
                return null;
            }
            IStatus iStatus = super.computeCompletionProposals(context, mode, proposals, monitor);
            return iStatus;
        }
        finally {
            this.sessionEnded();
        }
    }

    protected boolean include(Template template, String prefix) {
        String pattern = template.getPattern();
        int varIdx = pattern.indexOf("${");
        return (varIdx < 0 || varIdx >= prefix.length()) && pattern.startsWith(prefix);
    }

    protected String extractPrefix(AssistInvocationContext context) {
        IDocument document = context.getSourceViewer().getDocument();
        int offset = context.getOffset();
        try {
            int lineOffset = document.getLineOffset(document.getLineOfOffset(offset));
            String prefix = document.get(lineOffset, offset - lineOffset);
            List<String> indentPrefixes = this.markupLanguage.getIndentPrefixes();
            block2: while (!prefix.isEmpty()) {
                for (String indentPrefix : indentPrefixes) {
                    if (!prefix.startsWith(indentPrefix)) continue;
                    prefix = prefix.substring(indentPrefix.length());
                    continue block2;
                }
                return prefix;
            }
            return "";
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected TemplateContextType getContextType(AssistInvocationContext context, TextRegion region) {
        return this.markupLanguage != null ? this.getTypeRegistry().getContextType(String.valueOf(this.markupLanguage.getName()) + "weave_Weave:DocDefault") : null;
    }

    protected Image getImage(Template template) {
        return RedocsRUIResources.INSTANCE.getImage("org.eclipse.statet.redocs.r/image/obj/rchunk");
    }

    protected TemplateProposal createProposal(Template template, DocumentTemplateContext context, String prefix, TextRegion region, int relevance) {
        relevance = !prefix.isEmpty() && template.getPattern().startsWith(prefix) ? 95 : 0;
        return super.createProposal(template, context, prefix, region, relevance);
    }
}

