/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rhelp;

import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpView;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenRHelpHandler
extends AbstractHandler {
    private final REnv rEnv;
    private final RProcess tool;
    private final boolean reuse;

    public OpenRHelpHandler(REnv rEnv, RProcess tool, boolean reuse) {
        if (rEnv == null) {
            throw new NullPointerException("rEnv");
        }
        this.rEnv = rEnv;
        this.tool = tool;
        this.reuse = reuse;
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        return this.execute(event.getParameter("url"));
    }

    public @Nullable IStatus execute(String urlString) {
        final RProcess tool = this.tool;
        final URI url = urlString == null || urlString.isEmpty() || urlString.equals("about:blank") ? RCore.getRHelpHttpService().getREnvHttpUrl(this.rEnv, "browse") : RCore.getRHelpHttpService().toHttpUrl(urlString, this.rEnv, "browse");
        if (url == null) {
            return null;
        }
        try {
            UIAccess.checkedSyncExec((UIAccess.CheckedRunnable)new UIAccess.CheckedRunnable(){

                public void run() throws CoreException {
                    RHelpView view = (RHelpView)NicoUITools.getView((String)"org.eclipse.statet.r.views.RHelp", (ToolProcess)tool, (boolean)true);
                    view.openUrl(url, OpenRHelpHandler.this.reuse ? BrowserSession.findSessionByUrl((ImCollection)view.getSessions(), (URI)url) : null);
                }
            });
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.statet.r.ui", "An error occured when opening R help page in R help view.", (Throwable)e);
            StatusManager.getManager().handle((IStatus)status);
            return status;
        }
    }
}

