/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.tool;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.tool.IRConsoleService;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.services.FQRObject;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RGraphicCreator;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.statet.rj.ts.core.AbstractRToolRunnable;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class AbstractStatetRRunnable
extends AbstractRToolRunnable {
    protected static void checkNewCommand(IRConsoleService r, ProgressMonitor m) throws StatusException {
        if (!r.acceptNewConsoleCommand()) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "Operation cancelled because another command is already startedin the console.", null));
        }
    }

    public AbstractStatetRRunnable(String typeId, String label) {
        super(typeId, label);
    }

    protected void run(RToolService r, ProgressMonitor m) throws StatusException {
        if (r instanceof IRConsoleService) {
            this.run((IRConsoleService)r, m);
        } else {
            this.run(new RToolServiceWrapper(r), m);
        }
    }

    protected void run(IRConsoleService r, ProgressMonitor m) throws StatusException {
    }

    private static class RToolServiceWrapper
    implements IRConsoleService {
        private final RToolService service;

        public RToolServiceWrapper(RToolService service) {
            this.service = service;
        }

        public RTool getTool() {
            return this.service.getTool();
        }

        public RPlatform getPlatform() {
            return this.service.getPlatform();
        }

        public void evalVoid(String expression, ProgressMonitor m) throws StatusException {
            this.service.evalVoid(expression, m);
        }

        public void evalVoid(String expression, @Nullable RObject envir, ProgressMonitor m) throws StatusException {
            this.service.evalVoid(expression, m);
        }

        public RObject evalData(String expression, ProgressMonitor m) throws StatusException {
            return this.service.evalData(expression, m);
        }

        public RObject evalData(String expression, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
            return this.service.evalData(expression, factoryId, options, depth, m);
        }

        public RObject evalData(String expression, @Nullable RObject envir, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
            return this.service.evalData(expression, factoryId, options, depth, m);
        }

        public RObject evalData(RReference reference, ProgressMonitor m) throws StatusException {
            return this.service.evalData(reference, m);
        }

        public RObject evalData(RReference reference, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
            return this.service.evalData(reference, factoryId, options, depth, m);
        }

        public @Nullable FQRObject<? extends RTool> findData(String symbol, @Nullable RObject env, boolean inherits, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
            return this.service.findData(symbol, env, inherits, factoryId, options, depth, m);
        }

        public void assignData(String expression, RObject data, ProgressMonitor m) throws StatusException {
            this.service.assignData(expression, data, m);
        }

        public void uploadFile(InputStream in, long length, String fileName, int options, ProgressMonitor m) throws StatusException {
            this.service.uploadFile(in, length, fileName, options, m);
        }

        public void downloadFile(OutputStream out, String fileName, int options, ProgressMonitor m) throws StatusException {
            this.service.downloadFile(fileName, options, m);
        }

        public byte[] downloadFile(String fileName, int options, ProgressMonitor m) throws StatusException {
            return this.service.downloadFile(fileName, options, m);
        }

        public FunctionCall createFunctionCall(String name) throws StatusException {
            return this.service.createFunctionCall(name);
        }

        public RGraphicCreator createRGraphicCreator(int options) throws StatusException {
            return this.service.createRGraphicCreator(options);
        }

        @Override
        public boolean acceptNewConsoleCommand() {
            return true;
        }

        @Override
        public void submitToConsole(String input, ProgressMonitor m) throws StatusException {
            this.service.evalVoid("{\n" + input + "\n}", m);
        }

        @Override
        public void briefAboutToChange() {
        }

        @Override
        public void briefChanged(int o) {
        }
    }
}

