/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.PreferencesManageListener;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.resources.core.AbstractProjectNature;
import org.eclipse.statet.ecommons.resources.core.BuildUtils;
import org.eclipse.statet.ecommons.resources.core.ProjectUtils;
import org.eclipse.statet.internal.r.core.RBuildpathPrefs;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathElement;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.renv.IREnvManager;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvManager;
import org.eclipse.statet.rj.renv.core.REnvUtils;

@NonNullByDefault
public class RProjectNature
extends AbstractProjectNature
implements RProject,
PreferenceSetService.ChangeListener {
    public static final String OLD_QUALIFIER = "de.walware.r.core/RProjectBuild";
    public static final String RPKG_ROOT_FOLDER_PATH_KEY = "RPkgRootFolder.path";
    public static final String RENV_CODE_KEY = "REnv.code";
    private static final ImIdentitySet<String> PREF_QUALIFIERS = ImCollections.newIdentitySet((Object[])new String[]{"org.eclipse.statet.r.core/r.environments", "org.eclipse.statet.r.core/build/RProject"});
    private @Nullable String rPkgName;
    private PreferencesManageListener preferenceListener;
    private RCodeStyleSettings rCodeStyle;
    private @Nullable REnv rEnv;
    private RBuildpathPrefs rBuildpathPrefs;
    private ImList<IBuildpathElement> rRawBuildpath;

    public static @Nullable RProjectNature getRProject(@Nullable IProject project) {
        try {
            return project != null ? (RProjectNature)project.getNature("org.eclipse.statet.r.resourceProjects.R") : null;
        }
        catch (CoreException e) {
            RCorePlugin.log(e.getStatus());
            return null;
        }
    }

    public void setProject(IProject project) {
        super.setProject(project);
        this.addPreferenceSetListener(this, (ImSet)PREF_QUALIFIERS);
        this.updateREnv();
        this.rCodeStyle = new RCodeStyleSettings(1);
        this.preferenceListener = new PreferencesManageListener((AbstractPreferencesModelObject)this.rCodeStyle, this.getPrefs(), RCodeStyleSettings.ALL_GROUP_IDS);
        this.rBuildpathPrefs = new RBuildpathPrefs(this.getProjectContext(), "org.eclipse.statet.r.core/build/RProject", this.getProject());
        this.updateBuildpath();
        this.rPkgName = RCorePlugin.getInstance().getRModelManager().getIndex().getPkgName(project.getName());
        RCorePlugin.getInstance().getResourceTracker().register(project, this);
    }

    public void dispose() {
        RCorePlugin.getInstance().getResourceTracker().unregister(this.getProject());
        super.dispose();
        if (this.preferenceListener != null) {
            this.preferenceListener.dispose();
            this.preferenceListener = null;
        }
        this.rEnv = null;
    }

    public void deconfigure() throws CoreException {
        this.dispose();
        super.deconfigure();
    }

    public void addBuilders() throws CoreException {
        IProject project = this.getProject();
        IProjectDescription description = project.getDescription();
        boolean changed = false;
        if (changed |= ProjectUtils.addBuilder((IProjectDescription)description, (String)"org.eclipse.statet.r.resourceProjects.RBuilder")) {
            project.setDescription(description, null);
        }
    }

    public void removeBuilders() throws CoreException {
        IProject project = this.getProject();
        IProjectDescription description = project.getDescription();
        boolean changed = false;
        if (changed |= ProjectUtils.removeBuilder((IProjectDescription)description, (String)"org.eclipse.statet.r.resourceProjects.RBuilder")) {
            project.setDescription(description, null);
        }
    }

    public void preferenceChanged(PreferenceSetService.ChangeEvent event) {
        boolean clean = false;
        if (event.contains("org.eclipse.statet.r.core/r.environments") || event.contains(RProject.RENV_CODE_PREF)) {
            this.updateREnv();
        }
        if (event.contains("org.eclipse.statet.r.core/build/RProject", "stamp")) {
            this.updateBuildpath();
            clean = true;
        }
        if (event.contains(RProject.PKG_BASE_FOLDER_PATH_PREF)) {
            clean = true;
        }
        if (clean) {
            BuildUtils.getCleanJob((IProject)this.getProject(), (boolean)false).schedule();
        }
    }

    private void updateREnv() {
        IREnvManager rEnvManager = RCore.getREnvManager();
        String s = (String)this.getProjectValue(RProject.RENV_CODE_PREF);
        this.rEnv = s != null ? REnvUtils.decode((String)s, (REnvManager)rEnvManager) : rEnvManager.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBuildpath() {
        ImList<IBuildpathElement> rawBuildpath = this.rBuildpathPrefs.load();
        RProjectNature rProjectNature = this;
        synchronized (rProjectNature) {
            this.rRawBuildpath = rawBuildpath;
        }
    }

    @Override
    public PreferenceAccess getPrefs() {
        return this;
    }

    @Override
    public @Nullable REnv getREnv() {
        return this.rEnv;
    }

    @Override
    public RCodeStyleSettings getRCodeStyle() {
        return this.rCodeStyle;
    }

    @Override
    public @Nullable IPath getPkgRootPath() {
        IProject project = this.getProject();
        try {
            if (project.hasNature("org.eclipse.statet.r.resourceProjects.RPkg")) {
                IPath projectPath = this.getProject().getFullPath();
                String s = (String)this.getPreferenceValue(RProject.PKG_BASE_FOLDER_PATH_PREF);
                if (s != null) {
                    return projectPath.append(Path.fromPortableString((String)s));
                }
                return projectPath;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ImList<IBuildpathElement> getRawBuildpath() {
        return this.rRawBuildpath;
    }

    @Override
    public @Nullable String getPkgName() {
        return this.rPkgName;
    }

    public void updateRPkgConfig(@Nullable String pkgName) {
        boolean changed = pkgName != null ^ this.rPkgName != null;
        this.rPkgName = pkgName;
    }

    public void saveBuildpath(ImList<IBuildpathElement> rawBuildpath) {
        if (this.getRawBuildpath().equals(rawBuildpath)) {
            return;
        }
        this.rBuildpathPrefs.save((List<IBuildpathElement>)rawBuildpath, true);
    }
}

