/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.IUpdate;

public class TextViewerAction
extends Action
implements IUpdate {
    private final ITextOperationTarget fOperationTarget;
    private final int fOperationCode;

    public TextViewerAction(ITextViewer viewer, int operationCode) {
        assert (viewer != null);
        assert (operationCode != -1);
        this.fOperationCode = operationCode;
        this.fOperationTarget = viewer.getTextOperationTarget();
        this.update();
    }

    public void update() {
        this.setEnabled(this.fOperationTarget.canDoOperation(this.fOperationCode));
    }

    public void run() {
        if (this.fOperationTarget.canDoOperation(this.fOperationCode)) {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    public static TextViewerAction createDeleteAction(ITextViewer viewer) {
        TextViewerAction action = new TextViewerAction(viewer, 6);
        action.setId(ActionFactory.DELETE.getId());
        action.setActionDefinitionId("org.eclipse.ui.edit.delete");
        action.setText(SharedMessages.DeleteAction_name);
        action.setToolTipText(SharedMessages.DeleteAction_tooltip);
        return action;
    }

    public static TextViewerAction createCutAction(ITextViewer viewer) {
        TextViewerAction action = new TextViewerAction(viewer, 3);
        action.setId(ActionFactory.CUT.getId());
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        action.setText(SharedMessages.CutAction_name);
        action.setToolTipText(SharedMessages.CutAction_tooltip);
        return action;
    }

    public static TextViewerAction createCopyAction(ITextViewer viewer) {
        TextViewerAction action = new TextViewerAction(viewer, 4);
        action.setId(ActionFactory.COPY.getId());
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        action.setText(SharedMessages.CopyAction_name);
        action.setToolTipText(SharedMessages.CopyAction_tooltip);
        return action;
    }

    public static TextViewerAction createPasteAction(ITextViewer viewer) {
        TextViewerAction action = new TextViewerAction(viewer, 5);
        action.setId(ActionFactory.PASTE.getId());
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        action.setText(SharedMessages.PasteAction_name);
        action.setToolTipText(SharedMessages.PasteAction_tooltip);
        return action;
    }

    public static TextViewerAction createSelectAllAction(ITextViewer viewer) {
        TextViewerAction action = new TextViewerAction(viewer, 7);
        action.setId(ActionFactory.SELECT_ALL.getId());
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        action.setText(SharedMessages.SelectAllAction_name);
        action.setToolTipText(SharedMessages.SelectAllAction_tooltip);
        return action;
    }

    public static TextViewerAction createUndoAction(ITextViewer viewer) {
        TextViewerAction action = new TextViewerAction(viewer, 1);
        action.setId(ActionFactory.UNDO.getId());
        action.setActionDefinitionId("org.eclipse.ui.edit.undo");
        action.setText(SharedMessages.UndoAction_name);
        action.setToolTipText(SharedMessages.UndoAction_tooltip);
        return action;
    }

    public static TextViewerAction createRedoAction(ITextViewer viewer) {
        TextViewerAction action = new TextViewerAction(viewer, 2);
        action.setId(ActionFactory.REDO.getId());
        action.setActionDefinitionId("org.eclipse.ui.edit.redo");
        action.setText(SharedMessages.RedoAction_name);
        action.setToolTipText(SharedMessages.RedoAction_tooltip);
        return action;
    }
}

