/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.statet.ecommons.text.ISourceFragment;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;

public abstract class GenericFragmentSourceUnit
implements ISourceUnit {
    private final ElementName name;
    private final ISourceFragment fragment;
    private final long timestamp;
    private AbstractDocument document;
    private int counter = 0;

    public GenericFragmentSourceUnit(String id, ISourceFragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("fragment");
        }
        this.fragment = fragment;
        this.name = new ElementName(){

            @Override
            public int getType() {
                return 17;
            }

            @Override
            public String getDisplayName() {
                return GenericFragmentSourceUnit.this.fragment.getName();
            }

            @Override
            public String getSegmentName() {
                return GenericFragmentSourceUnit.this.fragment.getName();
            }

            @Override
            public ElementName getNextSegment() {
                return null;
            }
        };
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public ISourceUnit getUnderlyingUnit() {
        return null;
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }

    @Override
    public String getId() {
        return this.fragment.getId();
    }

    public ISourceFragment getFragment() {
        return this.fragment;
    }

    @Override
    public int getElementType() {
        return 640;
    }

    @Override
    public ElementName getElementName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return this.counter > 0;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        return false;
    }

    @Override
    public Object getResource() {
        return null;
    }

    @Override
    public synchronized AbstractDocument getDocument(IProgressMonitor monitor) {
        if (this.document == null) {
            this.document = this.fragment.getDocument();
        }
        return this.document;
    }

    @Override
    public long getContentStamp(IProgressMonitor monitor) {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceContent getContent(IProgressMonitor monitor) {
        AbstractDocument document = this.getDocument(monitor);
        Object lockObject = null;
        if (document instanceof ISynchronizable) {
            lockObject = ((ISynchronizable)document).getLockObject();
        }
        if (lockObject == null) {
            lockObject = this.fragment;
        }
        Object object = lockObject;
        synchronized (object) {
            return new SourceContent(document.getModificationStamp(), document.get());
        }
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == ISourceFragment.class) {
            return (T)this.fragment;
        }
        return null;
    }

    @Override
    public AstInfo getAstInfo(String type, boolean ensureSync, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ISourceUnitModelInfo getModelInfo(String type, int syncLevel, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public IModelElement getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return false;
    }

    @Override
    public List<? extends IModelElement> getModelChildren(IModelElement.Filter filter) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public final synchronized void connect(IProgressMonitor monitor) {
        ++this.counter;
        if (this.counter == 1) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            this.register();
        }
    }

    @Override
    public final synchronized void disconnect(IProgressMonitor monitor) {
        --this.counter;
        if (this.counter == 0) {
            this.unregister();
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.counter > 0;
    }

    protected void register() {
    }

    protected void unregister() {
    }

    public String toString() {
        return String.valueOf(this.getModelTypeId()) + '/' + this.getWorkingContext() + ": " + this.getId();
    }
}

