/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.core;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;

public class LTKUtils {
    public static IModelElement getModelElement(Object element) {
        if (element instanceof IModelElement) {
            return (IModelElement)element;
        }
        if (element instanceof IAdaptable) {
            return (IModelElement)((IAdaptable)element).getAdapter(IModelElement.class);
        }
        return null;
    }

    public static ISourceUnit getSourceUnit(IModelElement element) {
        if (element instanceof ISourceUnit) {
            return (ISourceUnit)element;
        }
        if (element instanceof ISourceElement) {
            return ((ISourceElement)element).getSourceUnit();
        }
        return null;
    }

    public static ISourceStructElement getCoveringSourceElement(ISourceStructElement root, TextRegion region) {
        return LTKUtils.getCoveringSourceElement(root, region.getStartOffset(), region.getEndOffset());
    }

    public static ISourceStructElement getCoveringSourceElement(ISourceStructElement root, int startOffset, int endOffset) {
        ISourceStructElement ok = root;
        block0: while (ok != null) {
            List<? extends ISourceStructElement> children = ok.getSourceChildren(null);
            for (ISourceStructElement iSourceStructElement : children) {
                int childEnd;
                int childOffset;
                TextRegion sourceRange = iSourceStructElement.getSourceRange();
                TextRegion docRange = iSourceStructElement.getDocumentationRange();
                int n = childOffset = docRange != null ? Math.min(sourceRange.getStartOffset(), docRange.getStartOffset()) : sourceRange.getStartOffset();
                if (startOffset < childOffset) break block0;
                int n2 = childEnd = docRange != null ? Math.max(sourceRange.getEndOffset(), docRange.getEndOffset()) : sourceRange.getEndOffset();
                if (!(startOffset < endOffset ? endOffset <= childEnd : endOffset < childEnd)) continue;
                ok = iSourceStructElement;
                continue block0;
            }
        }
        return ok;
    }

    public static int searchCoveringSourceElement(List<? extends ISourceStructElement> elements, int offset) {
        int low = 0;
        int high = elements.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            TextRegion region = elements.get(mid).getSourceRange();
            if (region.getEndOffset() < offset) {
                low = mid + 1;
                continue;
            }
            if (region.getStartOffset() > offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T extends ISourceStructElement> T getCoveringSourceElement(List<T> elements, int offset) {
        int idx = LTKUtils.searchCoveringSourceElement(elements, offset);
        if (idx >= 0) {
            return (T)((ISourceStructElement)elements.get(idx));
        }
        return null;
    }
}

