/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class SourceBlocks {
    private final ImList<SourceBlock> supportedBlocks;

    public SourceBlocks(SourceBlock ... blocks) {
        this((List<SourceBlock>)ImCollections.newList((Object[])blocks));
    }

    public SourceBlocks(List<SourceBlock> supportedBlocks) {
        this.supportedBlocks = ImCollections.toList(supportedBlocks);
    }

    public List<SourceBlockItem<?>> createItems(LineSequence lineSequence) {
        final ArrayList items = new ArrayList();
        SourceBlockBuilder sourceBlockBuilder = new SourceBlockBuilder();
        this.processItems(lineSequence, sourceBlockBuilder, this.supportedBlocks, new ItemRunnable(){

            @Override
            public void run(SourceBlockItem<?> blockItem) {
                items.add(blockItem);
            }
        });
        return items;
    }

    public void parseSourceStruct(final ProcessingContext context, LineSequence lineSequence, final DocumentBuilder builder) {
        context.setMode(3);
        SourceBlockBuilder sourceBlockBuilder = new SourceBlockBuilder();
        final CommonmarkLocator locator = new CommonmarkLocator();
        builder.setLocator((Locator)locator);
        this.processItems(lineSequence, sourceBlockBuilder, this.supportedBlocks, new ItemRunnable(){

            @Override
            public void run(SourceBlockItem<?> blockItem) {
                ((SourceBlock)blockItem.getType()).emit(context, blockItem, locator, builder);
            }
        });
    }

    private void processItems(LineSequence lineSequence, SourceBlockBuilder builder, ImList<? extends SourceBlock> supportedBlocks, ItemRunnable runnable) {
        CollectLineSequence collectLineSequence = new CollectLineSequence(lineSequence);
        SourceBlockItem<?> parentItem = builder.getCurrentItem();
        while (collectLineSequence.getCurrentLine() != null) {
            SourceBlock block = this.selectBlock(collectLineSequence, supportedBlocks, null);
            if (block != null) {
                collectLineSequence.initLines();
                block.createItem(builder, collectLineSequence);
                SourceBlockItem<?> blockItem = builder.getCurrentItem();
                blockItem.setLines(collectLineSequence.getLines());
                builder.setCurrentItem(parentItem);
                runnable.run(blockItem);
                continue;
            }
            return;
        }
    }

    public void initializeContext(ProcessingContext context, List<SourceBlockItem<?>> items) {
        context.setMode(1);
        for (SourceBlockItem<?> item : items) {
            ((SourceBlock)item.getType()).initializeContext(context, item);
        }
    }

    public void emit(ProcessingContext context, List<SourceBlockItem<?>> items, DocumentBuilder builder) {
        context.setMode(2);
        CommonmarkLocator locator = new CommonmarkLocator();
        builder.setLocator((Locator)locator);
        for (SourceBlockItem<?> item : items) {
            ((SourceBlock)item.getType()).emit(context, item, locator, builder);
        }
    }

    public @Nullable SourceBlock selectBlock(LineSequence lineSequence, SourceBlockItem<?> currentBlockItem) {
        return this.selectBlock(lineSequence, this.supportedBlocks, currentBlockItem);
    }

    public @Nullable SourceBlock selectBlock(LineSequence lineSequence) {
        return this.selectBlock(lineSequence, this.supportedBlocks, null);
    }

    public @Nullable SourceBlock selectBlock(LineSequence lineSequence, ImList<? extends SourceBlock> supportedBlocks, @Nullable SourceBlockItem<?> currentBlockItem) {
        for (SourceBlock candidate : supportedBlocks) {
            if (!candidate.canStart(lineSequence, currentBlockItem)) continue;
            return candidate;
        }
        return null;
    }

    private static class CollectLineSequence
    extends LineSequence {
        private final LineSequence delegate;
        private @Nullable Line currentLine;
        private final List<Line> lines = new ArrayList<Line>();

        public CollectLineSequence(LineSequence delegate) {
            this.delegate = delegate;
        }

        @Override
        public LineSequence lookAhead() {
            return this.delegate.lookAhead();
        }

        @Override
        public LineSequence lookAhead(int lineNumber) {
            return this.delegate.lookAhead(lineNumber);
        }

        @Override
        public @Nullable Line getCurrentLine() {
            this.currentLine = this.delegate.getCurrentLine();
            return this.currentLine;
        }

        @Override
        public @Nullable Line getNextLine() {
            return this.delegate.getNextLine();
        }

        @Override
        public void advance() {
            Line line = this.currentLine;
            if (line == null) {
                line = this.delegate.getCurrentLine();
            } else {
                this.currentLine = null;
            }
            this.delegate.advance();
            if (line != null) {
                this.lines.add(line);
            }
        }

        public ImList<Line> getLines() {
            return ImCollections.toList(this.lines);
        }

        public void initLines() {
            this.lines.clear();
        }
    }

    private static interface ItemRunnable {
        public void run(SourceBlockItem<?> var1);
    }

    public class SourceBlockBuilder {
        private SourceBlockItem<?> currentItem;

        private SourceBlockBuilder() {
        }

        void setCurrentItem(SourceBlockItem<?> blockItem) {
            this.currentItem = blockItem;
        }

        public SourceBlockItem<?> getCurrentItem() {
            return this.currentItem;
        }

        public SourceBlocks getSourceBlocks() {
            return SourceBlocks.this;
        }

        public void createNestedItems(LineSequence lineSequence, @Nullable ImList<? extends SourceBlock> supportedBlocks) {
            SourceBlocks.this.processItems(lineSequence, this, (ImList<? extends SourceBlock>)(supportedBlocks != null ? supportedBlocks : this.getSourceBlocks().supportedBlocks), new ItemRunnable(){

                @Override
                public void run(SourceBlockItem<?> blockItem) {
                }
            });
        }
    }
}

