/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.commonmark.core;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonRegex;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.util.HtmlUtils;

@NonNullByDefault
public class ParseHelper {
    private static final Pattern ESCAPING_PATTERN = Pattern.compile("\\\\(.)|&(#[Xx]\\p{XDigit}{1,8}|#\\p{Digit}{1,8}|\\p{Alpha}\\p{Alnum}{1,31});");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private final Matcher escapingMatcher = ESCAPING_PATTERN.matcher("");
    private final Matcher htmlEntityMatcher = CommonRegex.HTML_ENTITY_PATTERN.matcher("");
    private final Matcher whitespaceMatcher = WHITESPACE_PATTERN.matcher("");
    private final StringBuilder tmpBuilder = new StringBuilder(64);

    public Matcher getHtmlEntityMatcher() {
        return this.htmlEntityMatcher;
    }

    private Matcher getEscapingMatcher() {
        return this.escapingMatcher;
    }

    private Matcher getWhitespaceMatcher() {
        return this.whitespaceMatcher;
    }

    private StringBuilder getTmpBuilder() {
        this.tmpBuilder.setLength(0);
        return this.tmpBuilder;
    }

    public @Nullable String resolveHtmlEntity(String reference) {
        try {
            String replacement = HtmlUtils.resolveEntity((String)reference);
            if (replacement != null && replacement.charAt(0) == '\u0000') {
                throw new IllegalArgumentException();
            }
            return replacement;
        }
        catch (IllegalArgumentException e) {
            return "\ufffd";
        }
    }

    public String replaceHtmlEntities(String text, @Nullable Function<String, @NonNull String> escaper) {
        StringBuilder sb = this.getTmpBuilder();
        Matcher matcher = this.getHtmlEntityMatcher().reset(text);
        int lastEnd = 0;
        while (matcher.find()) {
            try {
                int start = matcher.start();
                String reference = matcher.group(1);
                String replacement = this.resolveHtmlEntity(reference);
                if (replacement == null) continue;
                if (escaper != null) {
                    replacement = escaper.apply(replacement);
                }
                if (lastEnd < start) {
                    sb.append(text, lastEnd, start);
                }
                sb.append(replacement);
                lastEnd = matcher.end();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (lastEnd == 0) {
            return text;
        }
        if (lastEnd < text.length()) {
            sb.append(text, lastEnd, text.length());
        }
        return sb.toString();
    }

    public String replaceEscaping(String text) {
        StringBuilder sb = this.getTmpBuilder();
        Matcher matcher = this.getEscapingMatcher().reset(text);
        int lastEnd = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int escapedIdx = matcher.start(1);
            if (escapedIdx >= 0) {
                if (!this.isAsciiPunctuation(text.charAt(escapedIdx))) continue;
                if (lastEnd < start) {
                    sb.append(text, lastEnd, start);
                }
                lastEnd = escapedIdx;
                continue;
            }
            try {
                String reference = matcher.group(2);
                String replacement = this.resolveHtmlEntity(reference);
                if (replacement == null) continue;
                if (lastEnd < start) {
                    sb.append(text, lastEnd, start);
                }
                sb.append(replacement);
                lastEnd = matcher.end();
            }
            catch (IllegalArgumentException e) {
                if (lastEnd < start) {
                    sb.append(text, lastEnd, start);
                }
                sb.append('\ufffd');
                lastEnd = matcher.end();
            }
        }
        if (lastEnd == 0) {
            return text;
        }
        if (lastEnd < text.length()) {
            sb.append(text, lastEnd, text.length());
        }
        return sb.toString();
    }

    public String collapseWhitespace(String text) {
        StringBuilder sb = this.getTmpBuilder();
        Matcher matcher = this.getWhitespaceMatcher().reset(text);
        int lastEnd = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start == 0) {
                lastEnd = matcher.end();
                continue;
            }
            sb.append(text, lastEnd, start);
            lastEnd = matcher.end();
            if (lastEnd == text.length()) break;
            sb.append(' ');
        }
        if (lastEnd == 0) {
            return text;
        }
        if (lastEnd < text.length()) {
            sb.append(text, lastEnd, text.length());
        }
        return sb.toString();
    }

    public boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public boolean isUnicodeWhitespace(char ch) {
        if (ch >= '\u0000' && ch < '\u1000') {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u00a0': {
                    return true;
                }
            }
            return false;
        }
        return Character.getType(ch) == 12;
    }

    public boolean isAsciiPunctuation(char ch) {
        switch (ch) {
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public boolean isPunctuation(char ch) {
        if (this.isAsciiPunctuation(ch)) {
            return true;
        }
        int type = Character.getType(ch);
        switch (type) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

