/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.AnonymousAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.sourcemodel.ElementAccess;
import org.eclipse.statet.internal.r.core.sourcemodel.IBuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceElements;
import org.eclipse.statet.internal.r.core.sourcemodel.SubNamedPartSyntacticElementAccess;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.model.IRClass;
import org.eclipse.statet.r.core.model.IRClassExtension;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.IRMethod;
import org.eclipse.statet.r.core.model.IRPackageLoad;
import org.eclipse.statet.r.core.model.IRSlot;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.rsource.ast.DocuComment;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.RAst;

abstract class RSourceElementByElementAccess
implements IRLangSourceElement,
IModelElement.Filter {
    private final IRLangSourceElement parent;
    private RElementAccess access;
    int type;
    int occurrenceCount;

    public RSourceElementByElementAccess(IRLangSourceElement parent, int elementType, ElementAccess defAccess) {
        this.parent = parent;
        this.type = elementType;
        this.setAccess(defAccess);
    }

    protected void setAccess(AnonymousAccess access) {
        if (access != null) {
            this.access = access;
        }
    }

    protected void setAccess(ElementAccess access) {
        if (access != null) {
            access.modelElement = this;
            this.access = access;
        }
    }

    public final String getModelTypeId() {
        return "R";
    }

    public final RElementAccess getAccess() {
        return this.access;
    }

    public boolean include(IModelElement element) {
        return element == this;
    }

    @Override
    public final IRElement getModelParent() {
        List<? extends IRElement> elements = this.access.getFrame().getModelElements();
        for (IRElement iRElement : elements) {
            if (!iRElement.hasModelChildren(this)) continue;
            return iRElement;
        }
        return null;
    }

    public final ISourceStructElement getSourceParent() {
        return this.parent;
    }

    @Override
    public final IRSourceUnit getSourceUnit() {
        return this.parent.getSourceUnit();
    }

    public final int getElementType() {
        return this.type;
    }

    @Override
    public final RElementName getElementName() {
        return this.access;
    }

    public final String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 10);
        sb.append(Integer.toHexString(this.type & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    public final boolean exists() {
        return this.parent.exists();
    }

    public final boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    public final TextRegion getSourceRange() {
        return this.access.getNode();
    }

    public final TextRegion getNameSourceRange() {
        RElementAccess access = this.access.getLastSegment();
        if (access.getNameNode() != null) {
            return RAst.getElementNameRegion(access.getNameNode());
        }
        return new BasicTextRegion(access.getNode().getStartOffset());
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.access.getNode());
        }
        if (adapterType == RElementAccess.class) {
            return (T)this.access;
        }
        return null;
    }

    public int hashCode() {
        return (this.type & 0xFF0) * this.getElementName().hashCode() + this.occurrenceCount;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RSourceElementByElementAccess)) {
            return false;
        }
        RSourceElementByElementAccess other = (RSourceElementByElementAccess)obj;
        return (this.type & 0xFF0) == (other.type & 0xFF0) && this.occurrenceCount == other.occurrenceCount && ((this.type & 0xF00) == 512 || this.getSourceParent().equals(other.getSourceParent())) && this.getElementName().equals(other.getElementName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" (RSourceElementByElementAccess)");
        RElementName elementName = this.getElementName();
        if (elementName != null) {
            sb.append(' ').append(elementName);
        } else {
            sb.append(" <unnamed>");
        }
        return sb.toString();
    }

    static abstract class DocuCommentableElement
    extends RSourceElementByElementAccess {
        private DocuComment docu;

        public DocuCommentableElement(IRLangSourceElement parent, int elementType, ElementAccess defAccess) {
            super(parent, elementType, defAccess);
        }

        void setDocu(DocuComment docu) {
            this.docu = docu;
        }

        public final DocuComment getDocumentationRange() {
            return this.docu;
        }
    }

    static final class RClass
    extends DocuCommentableElement
    implements IRClass,
    IBuildSourceFrameElement {
        private static final List<String> NO_PARENTS = Collections.emptyList();
        private List<? extends IRLangSourceElement> sourceChildrenProtected = RSourceElements.NO_R_SOURCE_CHILDREN;
        private List<? extends IRLangSourceElement> modelChildrenProtected;
        private final BuildSourceFrame envir;
        private List<String> superClassesTypeNames = NO_PARENTS;
        private List<String> superClassesTypeNamesProtected = NO_PARENTS;

        public RClass(IRLangSourceElement parent, ElementAccess defAccess, BuildSourceFrame envir) {
            super(parent, 1152, defAccess);
            this.envir = envir;
        }

        public void addSuperClasses(String[] typeNames) {
            int n;
            if (this.superClassesTypeNames == NO_PARENTS) {
                int count = 0;
                String[] stringArray = typeNames;
                int n2 = typeNames.length;
                n = 0;
                while (n < n2) {
                    String name = stringArray[n];
                    if (name != null) {
                        ++count;
                    }
                    ++n;
                }
                if (count == 0) {
                    return;
                }
                this.superClassesTypeNames = new ArrayList<String>(count);
                this.superClassesTypeNamesProtected = Collections.unmodifiableList(this.superClassesTypeNames);
            }
            String[] stringArray = typeNames;
            n = typeNames.length;
            int n3 = 0;
            while (n3 < n) {
                String name = stringArray[n3];
                if (name != null && !this.superClassesTypeNames.contains(name)) {
                    this.superClassesTypeNames.add(name);
                }
                ++n3;
            }
        }

        @Override
        public void setSourceChildren(List<? extends IRLangSourceElement> children) {
            this.sourceChildrenProtected = children;
        }

        @Override
        public BuildSourceFrame getBuildFrame() {
            return this.envir;
        }

        @Override
        public List<String> getExtendedClassNames() {
            return this.superClassesTypeNamesProtected;
        }

        @Override
        public boolean hasModelChildren(IModelElement.Filter filter) {
            if (this.modelChildrenProtected == null) {
                this.modelChildrenProtected = this.envir.getModelChildren(this);
            }
            return RSourceElements.hasChildren(this.modelChildrenProtected, filter);
        }

        @Override
        public List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
            if (this.modelChildrenProtected == null) {
                this.modelChildrenProtected = this.envir.getModelChildren(this);
            }
            return RSourceElements.getChildren(this.modelChildrenProtected, filter);
        }

        @Override
        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.hasChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.getChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType == IRFrame.class) {
                return (T)this.envir;
            }
            return super.getAdapter(adapterType);
        }
    }

    static final class RClassExt
    extends RSourceElementByElementAccess
    implements IRClassExtension,
    IBuildSourceFrameElement {
        private List<? extends IRLangSourceElement> sourceChildrenProtected = RSourceElements.NO_R_SOURCE_CHILDREN;
        private List<? extends IRLangSourceElement> modelChildrenProtected;
        private final BuildSourceFrame envir;
        private final String extCommand;
        private String extTypeName;

        public RClassExt(IRLangSourceElement parent, ElementAccess defAccess, BuildSourceFrame envir, String command) {
            super(parent, 1168, defAccess);
            this.envir = envir;
            this.extCommand = command;
        }

        public void complete(String extTypeName) {
            this.extTypeName = extTypeName;
        }

        @Override
        public void setSourceChildren(List<? extends IRLangSourceElement> children) {
            this.sourceChildrenProtected = children;
        }

        @Override
        public BuildSourceFrame getBuildFrame() {
            return this.envir;
        }

        @Override
        public String getExtCommand() {
            return this.extCommand;
        }

        @Override
        public String getExtTypeName() {
            return this.extTypeName;
        }

        public TextRegion getDocumentationRange() {
            return null;
        }

        @Override
        public boolean hasModelChildren(IModelElement.Filter filter) {
            if (this.modelChildrenProtected == null) {
                this.modelChildrenProtected = this.envir.getModelChildren(this);
            }
            return RSourceElements.hasChildren(this.modelChildrenProtected, filter);
        }

        @Override
        public List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
            if (this.modelChildrenProtected == null) {
                this.modelChildrenProtected = this.envir.getModelChildren(this);
            }
            return RSourceElements.getChildren(this.modelChildrenProtected, filter);
        }

        @Override
        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.hasChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.getChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType == IRFrame.class) {
                return (T)this.envir;
            }
            return super.getAdapter(adapterType);
        }
    }

    static final class RDataFrame
    extends DocuCommentableElement {
        private List<RElementAccess> columns;

        public RDataFrame(IRLangSourceElement parent, int elementType, List<SubNamedPartSyntacticElementAccess> columns) {
            super(parent, elementType, null);
        }

        @Override
        public boolean hasModelChildren(IModelElement.Filter filter) {
            return false;
        }

        @Override
        public final List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }

        @Override
        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return false;
        }

        @Override
        public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }
    }

    static final class RMethod
    extends DocuCommentableElement
    implements IRMethod,
    IBuildSourceFrameElement {
        private List<? extends IRLangSourceElement> sourceChildrenProtected = RSourceElements.NO_R_SOURCE_CHILDREN;
        private List<? extends IRLangSourceElement> modelChildrenProtected;
        private final BuildSourceFrame envir;
        private final FDef fDefNode;
        private ArgsDefinition args;

        public RMethod(IRLangSourceElement parent, BuildSourceFrame envir, FDef fdefNode) {
            super(parent, 1296, null);
            this.envir = envir;
            this.fDefNode = fdefNode;
        }

        void complete(int type, ElementAccess defAccess, ArgsDefinition args) {
            this.type = type;
            this.setAccess(defAccess);
            this.args = args;
        }

        void complete(AnonymousAccess defAccess, ArgsDefinition args) {
            this.setAccess(defAccess);
            this.args = args;
        }

        public RMethod(IRLangSourceElement parent, int type, ElementAccess access, BuildSourceFrame envir) {
            super(parent, type, access);
            this.envir = envir;
            this.fDefNode = null;
        }

        public void complete(ArgsDefinition args) {
            this.args = args;
        }

        @Override
        public void setSourceChildren(List<? extends IRLangSourceElement> children) {
            this.sourceChildrenProtected = children;
        }

        @Override
        public BuildSourceFrame getBuildFrame() {
            return this.envir;
        }

        public FDef getFDefNode() {
            return this.fDefNode;
        }

        @Override
        public ArgsDefinition getArgsDefinition() {
            return this.args;
        }

        @Override
        public boolean hasModelChildren(IModelElement.Filter filter) {
            if (this.modelChildrenProtected == null) {
                this.modelChildrenProtected = this.envir.getModelChildren(this);
            }
            return RSourceElements.hasChildren(this.modelChildrenProtected, filter);
        }

        @Override
        public List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
            if (this.modelChildrenProtected == null) {
                this.modelChildrenProtected = this.envir.getModelChildren(this);
            }
            return RSourceElements.getChildren(this.modelChildrenProtected, filter);
        }

        @Override
        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.hasChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.getChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType == IRFrame.class) {
                return (T)this.envir;
            }
            if (adapterType == FDef.class) {
                return (T)((Object)this.fDefNode);
            }
            return super.getAdapter(adapterType);
        }
    }

    static final class RPkgImport
    extends RSourceElementByElementAccess
    implements IRPackageLoad {
        public RPkgImport(IRLangSourceElement parent, ElementAccess access) {
            super(parent, 784, access);
        }

        public TextRegion getDocumentationRange() {
            return null;
        }

        @Override
        public boolean hasModelChildren(IModelElement.Filter filter) {
            return false;
        }

        @Override
        public final List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }

        @Override
        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return false;
        }

        @Override
        public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }
    }

    static final class RSlot
    extends RSourceElementByElementAccess
    implements IRSlot {
        private String typeName;
        private String prototypeCode;

        public RSlot(IRLangSourceElement parent, ElementAccess defAccess) {
            super(parent, 1664, defAccess);
        }

        void completeType(String name) {
            this.typeName = name;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        public TextRegion getDocumentationRange() {
            return null;
        }

        @Override
        public boolean hasModelChildren(IModelElement.Filter filter) {
            return false;
        }

        @Override
        public final List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }

        @Override
        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return false;
        }

        @Override
        public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }
    }

    static final class RVariable
    extends DocuCommentableElement {
        public RVariable(IRLangSourceElement parent, int elementType, ElementAccess defAccess) {
            super(parent, elementType, defAccess);
        }

        @Override
        public boolean hasModelChildren(IModelElement.Filter filter) {
            return false;
        }

        @Override
        public final List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }

        @Override
        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return false;
        }

        @Override
        public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
            return RSourceElements.NO_R_SOURCE_CHILDREN;
        }
    }
}

