/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.statet.ecommons.databinding.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.NotEmptyValidator;
import org.eclipse.statet.ecommons.databinding.core.observable.ComputedOnChangeValue;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;
import org.eclipse.statet.nico.ui.util.SubmitTypeSelectionComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TrackingConfigurationComposite
extends Composite {
    private Text nameControl;
    private Button streamInfoControl;
    private Button streamInputControl;
    private Button streamInputHistoryOnlyControl;
    private Button streamOutputErrorControl;
    private Button streamOutputErrorTruncateControl;
    private Text streamOutputErrorTruncateLinesControl;
    private SubmitTypeSelectionComposite submitTypeControl;
    private ResourceInputComposite filePathControl;
    private Button fileAppendControl;
    private Button fileOverwriteControl;
    private Button prependTimestampControl;
    private final List<SaveTemplate> saveTemplates = new ArrayList<SaveTemplate>();
    private TrackingConfiguration input;

    public TrackingConfigurationComposite(Composite parent) {
        super(parent, 0);
        this.configure();
        this.create();
    }

    protected boolean enableFullMode() {
        return true;
    }

    protected boolean enableFilePathAsCombo() {
        return false;
    }

    protected EnumSet<SubmitType> getEditableSubmitTypes() {
        return EnumSet.allOf(SubmitType.class);
    }

    protected void configure() {
    }

    protected void addSaveTemplate(SaveTemplate template) {
        this.saveTemplates.add(template);
    }

    protected void create() {
        Composite additionalComposite;
        Composite saveComposite;
        Composite contentComposite;
        Composite topComposite;
        this.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        if (this.enableFullMode() && (topComposite = this.createTopOptions(this)) != null) {
            topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        if ((contentComposite = this.createContentOptions(this)) != null) {
            contentComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        if ((saveComposite = this.createSaveOptions(this)) != null) {
            saveComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        if ((additionalComposite = this.createAdditionalOptions(this)) != null) {
            additionalComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    private Composite createTopOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText(Messages.Tracking_Name_label);
        Text text = new Text(composite, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)80);
        text.setLayoutData((Object)gd);
        this.nameControl = text;
        return composite;
    }

    private Composite createContentOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(String.valueOf(Messages.Tracking_Content_label) + ':');
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        this.streamInfoControl = new Button((Composite)composite, 32);
        this.streamInfoControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.streamInfoControl.setText(Messages.Tracking_InfoStream_label);
        this.streamInputControl = new Button((Composite)composite, 32);
        this.streamInputControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.streamInputControl.setText(Messages.Tracking_InputStream_label);
        if (this.enableFullMode()) {
            this.streamInputHistoryOnlyControl = new Button((Composite)composite, 32);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.horizontalIndent = LayoutUtils.defaultIndent();
            this.streamInputHistoryOnlyControl.setLayoutData((Object)gd);
            this.streamInputHistoryOnlyControl.setText(Messages.Tracking_InputStream_OnlyHistory_label);
            this.streamInputHistoryOnlyControl.setEnabled(false);
        }
        this.streamOutputErrorControl = new Button((Composite)composite, 32);
        this.streamOutputErrorControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.streamOutputErrorControl.setText(Messages.Tracking_OutputStream_label);
        Composite truncateRow = new Composite((Composite)composite, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        truncateRow.setLayoutData((Object)gd);
        truncateRow.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.streamOutputErrorTruncateControl = new Button(truncateRow, 32);
        this.streamOutputErrorTruncateControl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.streamOutputErrorTruncateControl.setText(Messages.Tracking_OutputStream_TruncateLines_label);
        this.streamOutputErrorTruncateControl.setEnabled(false);
        this.streamOutputErrorTruncateLinesControl = new Text(truncateRow, 133120);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)this.streamOutputErrorTruncateLinesControl, (int)10);
        this.streamOutputErrorTruncateLinesControl.setLayoutData((Object)gd);
        this.streamOutputErrorTruncateLinesControl.setEnabled(false);
        Label label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText(Messages.Tracking_Sources_label);
        this.submitTypeControl = new SubmitTypeSelectionComposite((Composite)composite);
        this.submitTypeControl.setEditable(this.getEditableSubmitTypes());
        this.submitTypeControl.setLayoutData(new GridData(16384, 0x1000000, false, false));
        return composite;
    }

    private Composite createSaveOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(String.valueOf(Messages.Tracking_File_label) + ':');
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        this.filePathControl = new ResourceInputComposite((Composite)composite, this.enableFilePathAsCombo() ? 1 : 0, 5, Messages.Tracking_File_label){

            protected void fillMenu(Menu menu) {
                super.fillMenu(menu);
                if (!TrackingConfigurationComposite.this.saveTemplates.isEmpty()) {
                    new MenuItem(menu, 2);
                    for (final SaveTemplate template : TrackingConfigurationComposite.this.saveTemplates) {
                        MenuItem item = new MenuItem(menu, 8);
                        item.setText(template.getLabel());
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                this.setText(template.getFilePath());
                                this.getTextControl().setFocus();
                            }
                        });
                    }
                }
            }
        };
        this.filePathControl.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
        this.filePathControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fileAppendControl = new Button((Composite)composite, 32);
        this.fileAppendControl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileAppendControl.setText(Messages.Tracking_File_Append_label);
        this.fileOverwriteControl = new Button((Composite)composite, 32);
        this.fileOverwriteControl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileOverwriteControl.setText(Messages.Tracking_File_Overwrite_label);
        return composite;
    }

    protected ResourceInputComposite getPathInput() {
        return this.filePathControl;
    }

    protected Composite createAdditionalOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(String.valueOf(Messages.Tracking_Actions_label) + ':');
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        this.addDefaultAdditionalOptions((Composite)composite);
        return composite;
    }

    protected Control addDefaultAdditionalOptions(Composite composite) {
        int columns = ((GridLayout)composite.getLayout()).numColumns;
        this.prependTimestampControl = new Button(composite, 32);
        this.prependTimestampControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns, 1));
        this.prependTimestampControl.setText(Messages.Tracking_Actions_PrependTimestamp_label);
        return this.prependTimestampControl;
    }

    protected void addBindings(DataBindingSupport db) {
        if (this.nameControl != null) {
            db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameControl), BeanProperties.value(TrackingConfiguration.class, (String)"name").observe((Object)this.input), new UpdateValueStrategy().setAfterGetValidator((IValidator)new NotEmptyValidator(Messages.Tracking_Name_error_Missing_message)), null);
        }
        ISWTObservableValue infoTargetObs = WidgetProperties.selection().observe((Widget)this.streamInfoControl);
        db.getContext().bindValue((IObservableValue)infoTargetObs, BeanProperties.value(TrackingConfiguration.class, (String)"trackStreamInfo").observe((Object)this.input));
        ISWTObservableValue inputTargetObs = WidgetProperties.selection().observe((Widget)this.streamInputControl);
        db.getContext().bindValue((IObservableValue)inputTargetObs, BeanProperties.value(TrackingConfiguration.class, (String)"trackStreamInput").observe((Object)this.input));
        if (this.streamInputHistoryOnlyControl != null) {
            db.getContext().bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.streamInputHistoryOnlyControl), (IObservableValue)inputTargetObs);
            db.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.streamInputHistoryOnlyControl), BeanProperties.value(TrackingConfiguration.class, (String)"trackStreamInputHistoryOnly").observe((Object)this.input));
        }
        ISWTObservableValue outputTargetObj = WidgetProperties.selection().observe((Widget)this.streamOutputErrorControl);
        final IObservableValue outputModelObs = BeanProperties.value(TrackingConfiguration.class, (String)"trackStreamOutput").observe((Object)this.input);
        db.getContext().bindValue((IObservableValue)outputTargetObj, outputModelObs);
        if (this.streamOutputErrorTruncateControl != null) {
            ISWTObservableValue outputTruncateTargetObs = WidgetProperties.selection().observe((Widget)this.streamOutputErrorTruncateControl);
            final IObservableValue outputTruncateModelObs = BeanProperties.value(TrackingConfiguration.class, (String)"trackStreamOutputTruncate").observe((Object)this.input);
            db.getContext().bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.streamOutputErrorTruncateControl), (IObservableValue)outputTargetObj);
            db.getContext().bindValue((IObservableValue)outputTruncateTargetObs, outputTruncateModelObs);
            db.getContext().bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.streamOutputErrorTruncateLinesControl), (IObservableValue)new ComputedOnChangeValue<Boolean>(Boolean.class, new IObservable[]{outputModelObs, outputTruncateModelObs}){

                protected Boolean calculate() {
                    Boolean one = (Boolean)outputModelObs.getValue();
                    Boolean two = (Boolean)outputTruncateModelObs.getValue();
                    return one != false && two != false;
                }
            });
            db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.streamOutputErrorTruncateLinesControl), BeanProperties.value(TrackingConfiguration.class, (String)"trackStreamOutputTruncateLines").observe((Object)this.input), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(2, 1000000, Messages.Tracking_OutputStream_TruncateLines_error_Invalid_message)), null);
        }
        if (this.submitTypeControl != null) {
            db.getContext().bindValue((IObservableValue)this.submitTypeControl.getObservable(), BeanProperties.value(TrackingConfiguration.class, (String)"submitTypes").observe((Object)this.input));
        }
        db.getContext().bindValue(this.filePathControl.getObservable(), BeanProperties.value(TrackingConfiguration.class, (String)"filePath").observe((Object)this.input), new UpdateValueStrategy().setAfterGetValidator((IValidator)this.filePathControl.getValidator()), null);
        final IObservableValue fileModeModelObs = BeanProperties.value(TrackingConfiguration.class, (String)"fileMode").observe((Object)this.input);
        db.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.fileAppendControl), (IObservableValue)new ComputedOnChangeValue<Boolean>(Boolean.class, new IObservable[]{fileModeModelObs}){

            protected Boolean calculate() {
                Integer mode = (Integer)fileModeModelObs.getValue();
                return (mode & 1) == 1;
            }

            protected void extractAndSet(Object value) {
                Boolean selected = (Boolean)value;
                fileModeModelObs.setValue((Object)(selected != false ? 1 : 0));
            }
        });
        db.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.fileOverwriteControl), (IObservableValue)new ComputedOnChangeValue<Boolean>(Boolean.class, new IObservable[]{fileModeModelObs}){

            protected Boolean calculate() {
                Integer mode = (Integer)fileModeModelObs.getValue();
                return (mode & 2) == 2;
            }

            protected void extractAndSet(Object value) {
                Boolean selected = (Boolean)value;
                fileModeModelObs.setValue((Object)(selected != false ? 2 : 0));
            }
        });
        if (this.prependTimestampControl != null) {
            db.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.prependTimestampControl), BeanProperties.value(TrackingConfiguration.class, (String)"prependTimestamp").observe((Object)this.input));
        }
    }

    public void setLabelEnabled(boolean enabled) {
        this.nameControl.setEnabled(enabled);
    }

    public void setStreamsEnabled(boolean enabled) {
        this.streamInfoControl.setEnabled(enabled);
        this.streamInputControl.setEnabled(enabled);
        if (this.streamInputHistoryOnlyControl != null) {
            this.streamInputHistoryOnlyControl.setEnabled(enabled);
        }
        this.streamOutputErrorControl.setEnabled(enabled);
    }

    public boolean getStreamsEnabled() {
        return this.streamInfoControl.getEnabled();
    }

    public void setSubmitTypesEnabled(boolean enabled) {
        this.submitTypeControl.setEnabled(enabled);
    }

    public boolean getSubmitTypesEnabled() {
        return this.submitTypeControl.getEnabled();
    }

    public void setInput(TrackingConfiguration config) {
        this.input = config;
    }

    public TrackingConfiguration getInput() {
        return this.input;
    }

    public static class SaveTemplate {
        private final String label;
        private final String filePath;

        public SaveTemplate(String label, String path) {
            this.label = label;
            this.filePath = path;
        }

        public String getLabel() {
            return this.label;
        }

        public String getFilePath() {
            return this.filePath;
        }
    }
}

