/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class IndentedCodeBlock
extends SourceBlock {
    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockItem<?> currentBlockItem) {
        Line line = lineSequence.getCurrentLine();
        return line != null && !line.isBlank() && line.getIndent() >= 4 && currentBlockItem == null;
    }

    @Override
    public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
        Line line;
        SourceBlockItem<IndentedCodeBlock> blockItem = new SourceBlockItem<IndentedCodeBlock>(this, builder);
        lineSequence.advance();
        while ((line = lineSequence.getCurrentLine()) != null) {
            if (line.isBlank()) {
                int end = this.lookAheadSafeLine(lineSequence.lookAhead());
                if (end == Integer.MIN_VALUE) break;
                IndentedCodeBlock.advanceLinesUpto(lineSequence, end);
                continue;
            }
            if (line.getIndent() < 4) break;
            lineSequence.advance();
        }
    }

    private int lookAheadSafeLine(LineSequence lineSequence) {
        Line line;
        while ((line = lineSequence.getCurrentLine()) != null) {
            if (line.isBlank()) {
                lineSequence.advance();
                continue;
            }
            if (line.getIndent() < 4) break;
            return line.getLineNumber();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void initializeContext(ProcessingContext context, SourceBlockItem<?> blockItem) {
    }

    @Override
    public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        ImList<Line> lines = blockItem.getLines();
        SourceElementAttributes attributes = new SourceElementAttributes(256);
        locator.setBlockBegin(blockItem);
        builder.beginBlock(DocumentBuilder.BlockType.CODE, (Attributes)attributes);
        for (Line line : lines) {
            if (line.getIndent() >= 4) {
                Line codeSegment = line.segmentByIndent(4);
                locator.setLine(codeSegment);
                builder.characters(codeSegment.getCodeContent());
                builder.characters("\n");
                continue;
            }
            builder.characters("\n");
        }
        locator.setBlockEnd(blockItem);
        builder.endBlock();
    }
}

