/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.event;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.IStructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.StructuralDiff;

public class StructuralRefreshEvent
implements IStructuralChangeEvent {
    private ILayer layer;

    public StructuralRefreshEvent(ILayer layer) {
        this.layer = layer;
    }

    protected StructuralRefreshEvent(StructuralRefreshEvent event) {
        this.layer = event.layer;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.layer = localLayer;
        return true;
    }

    @Override
    public Collection<LRectangle> getChangedPositionRectangles() {
        return Arrays.asList(new LRectangle(0L, 0L, this.layer.getColumnCount(), this.layer.getRowCount()));
    }

    @Override
    public boolean isHorizontalStructureChanged() {
        return true;
    }

    @Override
    public boolean isVerticalStructureChanged() {
        return true;
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        return null;
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        return null;
    }

    @Override
    public ILayerEvent cloneEvent() {
        return this;
    }
}

