/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.layer;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;
import org.eclipse.statet.ecommons.waltable.layer.cell.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;

public class AbstractPositionHeaderLayer
extends DimensionallyDependentLayer {
    private final Orientation headerOrientation;
    private final SelectionLayer selectionLayer;
    private final String fullySelectedLabel;

    public AbstractPositionHeaderLayer(ILayer baseLayer, Orientation orientation, ILayer contentLayerDependency, SelectionLayer selectionLayer, String fullySelectedLabel, ILayerPainter layerPainter) {
        super(baseLayer, orientation == Orientation.HORIZONTAL ? contentLayerDependency : baseLayer, orientation == Orientation.VERTICAL ? contentLayerDependency : baseLayer);
        if (selectionLayer == null) {
            throw new NullPointerException("selectionLayer");
        }
        this.headerOrientation = orientation;
        this.selectionLayer = selectionLayer;
        this.fullySelectedLabel = fullySelectedLabel;
        this.layerPainter = layerPainter;
    }

    @Override
    protected ILayerCell createCell(ILayerCellDim hDim, ILayerCellDim vDim, ILayerCell underlyingCell) {
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell){

            @Override
            public DisplayMode getDisplayMode() {
                if (AbstractPositionHeaderLayer.this.isSelected(this.getDim(AbstractPositionHeaderLayer.this.headerOrientation))) {
                    return DisplayMode.SELECT;
                }
                return super.getDisplayMode();
            }

            @Override
            public LabelStack getConfigLabels() {
                LabelStack configLabels = super.getConfigLabels();
                if (AbstractPositionHeaderLayer.this.isFullySelected(this.getDim(AbstractPositionHeaderLayer.this.headerOrientation))) {
                    configLabels.addLabel(AbstractPositionHeaderLayer.this.fullySelectedLabel);
                }
                return configLabels;
            }
        };
    }

    protected boolean isSelected(ILayerCellDim dim) {
        long position;
        ILayerDim layerDim = this.getDim(this.headerOrientation);
        if (this.selectionLayer.isPositionSelected(this.headerOrientation, LayerUtil.convertPosition(layerDim, position = dim.getPosition(), position, this.selectionLayer.getDim(this.headerOrientation)))) {
            return true;
        }
        if (dim.getPositionSpan() > 1L) {
            long iPosition = dim.getOriginPosition();
            long endPosition = iPosition + dim.getPositionSpan();
            while (iPosition < endPosition) {
                if (iPosition != position && this.selectionLayer.isPositionSelected(this.headerOrientation, LayerUtil.convertPosition(layerDim, position, iPosition, this.selectionLayer.getDim(this.headerOrientation)))) {
                    return true;
                }
                ++iPosition;
            }
        }
        return false;
    }

    protected boolean isFullySelected(ILayerCellDim dim) {
        long position;
        ILayerDim layerDim = this.getDim(this.headerOrientation);
        if (!this.selectionLayer.isPositionFullySelected(this.headerOrientation, LayerUtil.convertPosition(layerDim, position = dim.getPosition(), position, this.selectionLayer.getDim(this.headerOrientation)))) {
            return false;
        }
        if (dim.getPositionSpan() > 1L) {
            long iPosition = dim.getOriginPosition();
            long endPosition = iPosition + dim.getPositionSpan();
            while (iPosition < endPosition) {
                if (iPosition != position && !this.selectionLayer.isPositionFullySelected(this.headerOrientation, LayerUtil.convertPosition(layerDim, position, iPosition, this.selectionLayer.getDim(this.headerOrientation)))) {
                    return false;
                }
                ++iPosition;
            }
        }
        return true;
    }
}

