/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.data;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.data.IColumnPropertyAccessor;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;

public class ReflectiveColumnPropertyAccessor<R>
implements IColumnPropertyAccessor<R> {
    private final List<String> propertyNames;
    private Map<String, PropertyDescriptor> propertyDescriptorMap;

    public ReflectiveColumnPropertyAccessor(String[] propertyNames) {
        this.propertyNames = Arrays.asList(propertyNames);
    }

    @Override
    public long getColumnCount() {
        return this.propertyNames.size();
    }

    @Override
    public Object getDataValue(R rowObj, long columnIndex) {
        try {
            PropertyDescriptor propertyDesc = this.getPropertyDescriptor(rowObj, columnIndex);
            Method readMethod = propertyDesc.getReadMethod();
            return readMethod.invoke(rowObj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDataValue(R rowObj, long columnIndex, Object newValue) {
        try {
            PropertyDescriptor propertyDesc = this.getPropertyDescriptor(rowObj, columnIndex);
            Method writeMethod = propertyDesc.getWriteMethod();
            if (writeMethod == null) {
                throw new RuntimeException("Setter method not found in backing bean for value at column index: " + columnIndex);
            }
            writeMethod.invoke(rowObj, newValue);
        }
        catch (IllegalArgumentException ex) {
            WaLTablePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ecommons.waltable.core", "Data type being set does not match the data type of the setter method in the backing bean", (Throwable)ex));
        }
        catch (Exception e) {
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Error while setting data value", (Throwable)e));
            throw new RuntimeException("Error while setting data value");
        }
    }

    @Override
    public String getColumnProperty(long columnIndex) {
        if (columnIndex >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return this.propertyNames.get((int)columnIndex);
    }

    @Override
    public long getColumnIndex(String propertyName) {
        return this.propertyNames.indexOf(propertyName);
    }

    private PropertyDescriptor getPropertyDescriptor(R rowObj, long columnIndex) throws IntrospectionException {
        if (columnIndex >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        if (this.propertyDescriptorMap == null) {
            PropertyDescriptor[] propertyDescriptors;
            this.propertyDescriptorMap = new HashMap<String, PropertyDescriptor>();
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = Introspector.getBeanInfo(rowObj.getClass()).getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                this.propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
                ++n2;
            }
        }
        String propertyName = this.propertyNames.get((int)columnIndex);
        return this.propertyDescriptorMap.get(propertyName);
    }
}

