/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.rules.BufferedDocumentScanner;

public class CharacterScannerReader {
    private final BufferedDocumentScanner scanner;
    private int offset;

    public CharacterScannerReader(BufferedDocumentScanner scanner) {
        this.scanner = scanner;
    }

    public final BufferedDocumentScanner getScanner() {
        return this.scanner;
    }

    public final int read() {
        int c = this.scanner.read();
        if (c >= 0) {
            ++this.offset;
        }
        return c;
    }

    public final boolean read(char c1) {
        int c = this.scanner.read();
        if (c == c1) {
            ++this.offset;
            return true;
        }
        if (c >= 0) {
            this.scanner.unread();
        }
        return false;
    }

    public final boolean read(char c1, char c2) {
        int c = this.scanner.read();
        if (c == c1) {
            c = this.scanner.read();
            if (c == c2) {
                this.offset += 2;
                return true;
            }
            this.scanner.unread();
        }
        if (c >= 0) {
            this.scanner.unread();
        }
        return false;
    }

    public final boolean read(char c1, char c2, char c3) {
        int c = this.scanner.read();
        if (c == c1) {
            c = this.scanner.read();
            if (c == c2) {
                c = this.scanner.read();
                if (c == c3) {
                    this.offset += 3;
                    return true;
                }
                this.scanner.unread();
            }
            this.scanner.unread();
        }
        if (c >= 0) {
            this.scanner.unread();
        }
        return false;
    }

    public final boolean read2(char[] cSeq) {
        int i = 1;
        while (i < cSeq.length) {
            int c = this.scanner.read();
            if (c != cSeq[i]) {
                this.unreadRaw(c >= 0 ? i : i - 1);
                return false;
            }
            ++i;
        }
        this.offset += cSeq.length - 1;
        return true;
    }

    public final boolean readConsuming(char c1, char c2) {
        int c = this.scanner.read();
        if (c == c1 && (c = this.scanner.read()) == c2) {
            this.offset += 2;
            return true;
        }
        if (c >= 0) {
            this.scanner.unread();
        }
        return false;
    }

    public final boolean readConsuming(char[] seq) {
        int n = seq.length;
        int i = 0;
        while (i < n) {
            int c = this.scanner.read();
            if (c != seq[i]) {
                this.offset += i;
                if (c >= 0) {
                    this.scanner.unread();
                }
                return false;
            }
            ++i;
        }
        this.offset += n;
        return true;
    }

    public final boolean readConsuming2(char[] cSeq) {
        int n = cSeq.length;
        int i = 1;
        while (i < n) {
            int c = this.scanner.read();
            if (c != cSeq[i]) {
                this.offset += i - 1;
                if (c >= 0) {
                    this.scanner.unread();
                }
                return false;
            }
            ++i;
        }
        this.offset += n - 1;
        return true;
    }

    public final int readConsumingWhitespace() {
        int readed = 0;
        while (true) {
            int c;
            if ((c = this.scanner.read()) != 32 && c != 9) {
                if (c >= 0) {
                    this.scanner.unread();
                }
                this.offset += readed;
                return readed;
            }
            ++readed;
        }
    }

    public final boolean readTemp(char c1) {
        int c = this.scanner.read();
        if (c >= 0) {
            this.scanner.unread();
        }
        return c == c1;
    }

    public final boolean readTemp(char c1, char c2) {
        int c = this.scanner.read();
        if (c == c1) {
            c = this.scanner.read();
            if (c == c2) {
                return true;
            }
            this.scanner.unread();
        }
        if (c >= 0) {
            this.scanner.unread();
        }
        return false;
    }

    public final void unread() {
        --this.offset;
        this.scanner.unread();
    }

    public final void unread(int count) {
        this.offset -= count;
        while (count-- > 0) {
            this.scanner.unread();
        }
    }

    public final int readRaw() {
        return this.scanner.read();
    }

    public final void unreadRaw(int count) {
        while (count-- > 0) {
            this.scanner.unread();
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void setRange(IDocument document, int startOffset, int length) {
        this.scanner.setRange(document, startOffset, length);
        this.offset = startOffset;
    }
}

