/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.QuickTreeInformationControl;
import org.eclipse.statet.internal.ltk.ui.LTKUIPlugin;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.OutlineContentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.actions.OpenDeclaration;
import org.eclipse.swt.widgets.Shell;

public abstract class QuickOutlineInformationControl
extends QuickTreeInformationControl {
    protected static final String INHERITED_COLOR_NAME = "org.eclipse.jdt.ui.ColoredLabels.inherited";
    private final OpenDeclaration opener;
    private OutlineContentProvider contentProvider;
    private boolean requireFullName;

    public QuickOutlineInformationControl(Shell parent, String commandId, int pageCount, OpenDeclaration opener) {
        super(parent, 16, true, commandId, pageCount);
        this.opener = opener;
    }

    public abstract String getModelTypeId();

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getSection((IDialogSettings)LTKUIPlugin.getInstance().getDialogSettings(), (String)"EditorStructurePopup");
    }

    protected String getDescription(int page) {
        if (this.getCommandId() == "org.eclipse.statet.ltk.commands.ShowQuickSourceOutline") {
            return "Document Outline";
        }
        if (this.getCommandId() == "org.eclipse.statet.ltk.commands.ShowQuickElementOutline") {
            return "Object Outline";
        }
        return "";
    }

    protected void setMatcherString(String pattern, boolean update) {
        this.requireFullName = pattern.indexOf(42) >= 0;
        super.setMatcherString(pattern, update);
    }

    protected String getElementName(IAdaptable element) {
        if (element instanceof IModelElement && !this.requireFullName) {
            return ((IModelElement)element).getElementName().getSegmentName();
        }
        return super.getElementName(element);
    }

    protected void configureViewer(TreeViewer viewer) {
        this.contentProvider = this.createContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected OutlineContentProvider createContentProvider() {
        return new OutlineContentProvider(new OutlineContent());
    }

    protected ISourceUnitModelInfo getModelInfo(Object input) {
        if (input instanceof ISourceUnit) {
            return ((ISourceUnit)input).getModelInfo(this.getModelTypeId(), 0, null);
        }
        return null;
    }

    protected IModelElement.Filter getContentFilter() {
        return null;
    }

    protected int getInitialIterationPage(ISourceElement element) {
        return 0;
    }

    public void setInput(Object information) {
        ISourceElement element;
        ISourceUnit su;
        if (information instanceof ISourceElement && (su = (element = (ISourceElement)information).getSourceUnit()) != null) {
            this.inputChanged(this.getInitialIterationPage(element), su, element);
            return;
        }
        this.inputChanged(0, null, null);
    }

    protected void openElement(Object element) throws CoreException {
        if (element instanceof ISourceElement) {
            this.opener.open((ISourceElement)element, true);
        }
    }

    protected class OutlineContent
    implements OutlineContentProvider.IOutlineContent {
        @Override
        public ISourceUnitModelInfo getModelInfo(Object input) {
            return QuickOutlineInformationControl.this.getModelInfo(input);
        }

        @Override
        public IModelElement.Filter getContentFilter() {
            return QuickOutlineInformationControl.this.getContentFilter();
        }
    }
}

