/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.ToolSessionUIData;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.r.launching.IRCodeSubmitConnector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class RControllerCodeLaunchConnector
implements IRCodeSubmitConnector {
    public static final String ID = "org.eclipse.statet.r.rCodeLaunchConnector.RNewConsoleConnector";

    @Override
    public boolean submit(final List<String> lines, boolean gotoConsole) throws CoreException {
        return this.submit(new CommandsCreator(){

            @Override
            public Status submitTo(ToolController controller) {
                return controller.submit(lines, SubmitType.EDITOR);
            }
        }, gotoConsole);
    }

    public boolean submit(CommandsCreator rCommands, boolean gotoConsole) throws CoreException {
        final AtomicReference info = new AtomicReference();
        UIAccess.checkedSyncExec((UIAccess.CheckedRunnable)new UIAccess.CheckedRunnable(){

            public void run() throws CoreException {
                IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
                info.set(NicoUI.getToolRegistry().getActiveToolSession(page));
            }
        });
        ToolController controller = NicoUITools.accessController((String)"R", (ToolProcess)((ToolSessionUIData)info.get()).getProcess());
        Status status = rCommands.submitTo(controller);
        if (status.getSeverity() >= 4) {
            throw new CoreException(StatusUtils.convert((Status)status));
        }
        NIConsole console = ((ToolSessionUIData)info.get()).getConsole();
        if (console != null) {
            NicoUITools.showConsole((NIConsole)console, (IWorkbenchPage)((ToolSessionUIData)info.get()).getPage(), (boolean)gotoConsole);
        }
        return true;
    }

    @Override
    public void gotoConsole() throws CoreException {
        IEditorStatusLine statusLine;
        IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
        ToolSessionUIData info = NicoUI.getToolRegistry().getActiveToolSession(page);
        NIConsole console = info.getConsole();
        if (console != null) {
            NicoUITools.showConsole((NIConsole)console, (IWorkbenchPage)page, (boolean)true);
            return;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part != null && (statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class)) != null) {
            statusLine.setMessage(true, RLaunchingMessages.SubmitCode_error_NoRSession_message, null);
        }
        Display.getCurrent().beep();
    }

    public static interface CommandsCreator {
        public Status submitTo(ToolController var1);
    }
}

