/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.IIndentSettings;

public class WikitextCodeStyleSettings
extends AbstractPreferencesModelObject
implements IIndentSettings {
    public static final String QUALIFIER = "org.eclipse.statet.docmlet.wikitext.core/codestyle/Wikitext";
    public static final String INDENT_GROUP_ID = "Wikitext/Wikitext.codestyle/indent";
    public static final String[] ALL_GROUP_IDS = new String[]{"Wikitext/Wikitext.codestyle/indent"};
    public static final Preference.IntPref TAB_SIZE_PREF = new Preference.IntPref("org.eclipse.statet.docmlet.wikitext.core/codestyle/Wikitext", "Tab.size");
    public static final Preference.EnumPref<IIndentSettings.IndentationType> INDENT_DEFAULT_TYPE_PREF = new Preference.EnumPref("org.eclipse.statet.docmlet.wikitext.core/codestyle/Wikitext", "Indent.type", IIndentSettings.IndentationType.class);
    public static final Preference.IntPref INDENT_SPACES_COUNT_PREF = new Preference.IntPref("org.eclipse.statet.docmlet.wikitext.core/codestyle/Wikitext", "Indent.Level.spaces_count");
    public static final Preference.BooleanPref REPLACE_CONVERSATIVE_PREF = new Preference.BooleanPref("org.eclipse.statet.docmlet.wikitext.core/codestyle/Wikitext", "Indent.ReplaceConservativ.enabled");
    public static final Preference.BooleanPref REPLACE_TABS_WITH_SPACES_PREF = new Preference.BooleanPref("org.eclipse.statet.docmlet.wikitext.core/codestyle/Wikitext", "Indent.ReplaceOtherTabs.enabled");
    public static final Preference<Integer> WRAP_LINE_WIDTH_PREF = new Preference.IntPref("org.eclipse.statet.docmlet.wikitext.core/codestyle/Wikitext", "Wrap.LineWidth.max");
    private int tabSize;
    private IIndentSettings.IndentationType indentDefaultType;
    private int indentSpacesCount;
    private boolean replaceOtherTabsWithSpaces;
    private boolean replaceConservative;
    private int lineWidth;

    public WikitextCodeStyleSettings(int mode) {
        if (mode >= 1) {
            this.installLock();
        }
        this.loadDefaults();
        this.resetDirty();
    }

    public String[] getNodeQualifiers() {
        return new String[]{QUALIFIER};
    }

    public void loadDefaults() {
        this.setTabSize(4);
        this.setIndentDefaultType(IIndentSettings.IndentationType.SPACES);
        this.setIndentSpacesCount(4);
        this.setReplaceConservative(false);
        this.setReplaceOtherTabsWithSpaces(false);
        this.setLineWidth(80);
    }

    public void load(PreferenceAccess prefs) {
        this.setTabSize((Integer)prefs.getPreferenceValue((Preference)TAB_SIZE_PREF));
        this.setIndentDefaultType((IIndentSettings.IndentationType)prefs.getPreferenceValue(INDENT_DEFAULT_TYPE_PREF));
        this.setIndentSpacesCount((Integer)prefs.getPreferenceValue((Preference)INDENT_SPACES_COUNT_PREF));
        this.setReplaceConservative((Boolean)prefs.getPreferenceValue((Preference)REPLACE_CONVERSATIVE_PREF));
        this.setReplaceOtherTabsWithSpaces((Boolean)prefs.getPreferenceValue((Preference)REPLACE_TABS_WITH_SPACES_PREF));
        this.setLineWidth((Integer)prefs.getPreferenceValue(WRAP_LINE_WIDTH_PREF));
    }

    public void load(WikitextCodeStyleSettings source) {
        Lock writeLock = this.getWriteLock();
        Lock sourceLock = source.getReadLock();
        try {
            sourceLock.lock();
            writeLock.lock();
            this.setTabSize(source.tabSize);
            this.setIndentDefaultType(source.indentDefaultType);
            this.setIndentSpacesCount(source.indentSpacesCount);
            this.setReplaceConservative(source.replaceConservative);
            this.setReplaceOtherTabsWithSpaces(source.replaceOtherTabsWithSpaces);
            this.setLineWidth(source.lineWidth);
        }
        finally {
            sourceLock.unlock();
            writeLock.unlock();
        }
    }

    public Map<Preference<?>, Object> deliverToPreferencesMap(Map<Preference<?>, Object> map) {
        map.put((Preference<?>)TAB_SIZE_PREF, this.getTabSize());
        map.put((Preference<?>)INDENT_DEFAULT_TYPE_PREF, this.getIndentDefaultType());
        map.put((Preference<?>)INDENT_SPACES_COUNT_PREF, this.getIndentSpacesCount());
        map.put((Preference<?>)REPLACE_CONVERSATIVE_PREF, this.getReplaceConservative());
        map.put((Preference<?>)REPLACE_TABS_WITH_SPACES_PREF, this.getReplaceOtherTabsWithSpaces());
        map.put(WRAP_LINE_WIDTH_PREF, this.getLineWidth());
        return map;
    }

    public void setTabSize(int size) {
        int oldValue = this.tabSize;
        this.tabSize = size;
        this.firePropertyChange("tabSize", oldValue, size);
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setIndentDefaultType(IIndentSettings.IndentationType type) {
        IIndentSettings.IndentationType oldValue = this.indentDefaultType;
        this.indentDefaultType = type;
        this.firePropertyChange("indentDefaultType", oldValue, type);
    }

    public IIndentSettings.IndentationType getIndentDefaultType() {
        return this.indentDefaultType;
    }

    public void setIndentSpacesCount(int count) {
        int oldValue = this.indentSpacesCount;
        this.indentSpacesCount = count;
        this.firePropertyChange("indentSpacesCount", oldValue, count);
    }

    public int getIndentSpacesCount() {
        return this.indentSpacesCount;
    }

    public void setReplaceConservative(boolean enable) {
        boolean oldValue = this.replaceConservative;
        this.replaceConservative = enable;
        this.firePropertyChange("replaceConservative", oldValue, enable);
    }

    public boolean getReplaceConservative() {
        return this.replaceConservative;
    }

    public void setReplaceOtherTabsWithSpaces(boolean enable) {
        boolean oldValue = this.replaceOtherTabsWithSpaces;
        this.replaceOtherTabsWithSpaces = enable;
        this.firePropertyChange("replaceOtherTabsWithSpaces", oldValue, this.getReplaceOtherTabsWithSpaces());
    }

    public boolean getReplaceOtherTabsWithSpaces() {
        return this.replaceOtherTabsWithSpaces;
    }

    public void setLineWidth(int max) {
        int oldValue = this.lineWidth;
        this.lineWidth = max;
        this.firePropertyChange("lineWidth", oldValue, max);
    }

    public int getLineWidth() {
        return this.lineWidth;
    }
}

