/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.waltable.config.AbstractRegistryConfiguration;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.config.LayoutSizeConfig;
import org.eclipse.statet.ecommons.waltable.freeze.IFreezeConfigAttributes;
import org.eclipse.statet.ecommons.waltable.grid.labeled.CornerGridLineCellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.DiagCellPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.statet.ecommons.waltable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.statet.ecommons.waltable.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.style.Style;
import org.eclipse.statet.ecommons.waltable.style.VerticalAlignment;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.intable.RTextPainter;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.themes.ColorUtil;

public class PresentationConfig
extends AbstractRegistryConfiguration
implements Disposable,
IPropertyChangeListener {
    private static PresentationConfig gInstance;
    private final Display display;
    private final Color headerGridColor;
    private final Color headerBackgroundColor;
    private final Color headerForegroundColor;
    private final Color bodyGridColor;
    private final Color bodyBackgroundColor;
    private final Color bodyEvenRowBackgroundColor;
    private final Color bodyOddRowBackgroundColor;
    private final Color bodyForegroundColor;
    private final Color headerSelectionBackgroundColor;
    private final Color headerSelectionForegroundColor;
    private final Color headerPlaceholderColor;
    private final Color headerFullSelectionBackgroundColor;
    private final Color headerFullSelectionForegroundColor;
    private final Color bodySelectionBackgroundColor;
    private final Color bodySelectionForegroundColor;
    private final Color bodyFreezeSeparatorColor;
    private final ILayerPainter headerLayerPainter;
    private final ILayerPainter headerLabelLayerPainter;
    private ICellPainter baseCellPainter;
    private ICellPainter headerCellPainter;
    private ICellPainter headerSortedCellPainter;
    private ICellPainter headerCornerCellPainter;
    private final BorderStyle bodyAnchorBorderStyle;
    private Font baseFont;
    private Font infoFont;
    private LayoutSizeConfig baseSizeConfig;
    private final CopyOnWriteIdentityListSet<Runnable> listeners = new CopyOnWriteIdentityListSet();

    public static PresentationConfig getInstance(Display display) {
        if (gInstance == null) {
            gInstance = new PresentationConfig(display);
            RUIPlugin.getInstance().registerPluginDisposable(gInstance);
        }
        return gInstance;
    }

    public PresentationConfig(Display display) {
        this.display = display;
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        this.headerGridColor = display.getSystemColor(16);
        this.headerBackgroundColor = display.getSystemColor(22);
        this.headerForegroundColor = display.getSystemColor(21);
        this.bodyGridColor = display.getSystemColor(15);
        this.bodyEvenRowBackgroundColor = this.bodyBackgroundColor = display.getSystemColor(25);
        this.bodyOddRowBackgroundColor = new Color((Device)display, ColorUtil.blend((RGB)display.getSystemColor(19).getRGB(), (RGB)this.bodyEvenRowBackgroundColor.getRGB(), (int)20));
        this.bodyForegroundColor = display.getSystemColor(24);
        this.headerSelectionBackgroundColor = new Color((Device)display, ColorUtil.blend((RGB)display.getSystemColor(26).getRGB(), (RGB)this.headerBackgroundColor.getRGB(), (int)25));
        this.headerSelectionForegroundColor = this.headerForegroundColor;
        this.headerPlaceholderColor = new Color((Device)display, ColorUtil.blend((RGB)this.bodyGridColor.getRGB(), (RGB)this.headerBackgroundColor.getRGB(), (int)25));
        this.headerFullSelectionBackgroundColor = new Color((Device)display, ColorUtil.blend((RGB)display.getSystemColor(26).getRGB(), (RGB)display.getSystemColor(18).getRGB(), (int)25));
        this.headerFullSelectionForegroundColor = display.getSystemColor(20);
        this.bodySelectionBackgroundColor = display.getSystemColor(26);
        this.bodySelectionForegroundColor = display.getSystemColor(27);
        this.bodyFreezeSeparatorColor = colorRegistry.get("DECORATIONS_COLOR");
        this.headerLayerPainter = new GridLineCellLayerPainter(this.headerGridColor);
        this.headerLabelLayerPainter = new CornerGridLineCellLayerPainter(this.headerGridColor);
        this.bodyAnchorBorderStyle = new BorderStyle(2, this.bodyForegroundColor, BorderStyle.LineStyle.SOLID, -1);
        this.updateFonts();
        this.updateCellPainters();
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        fontRegistry.addListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        if (fontRegistry != null) {
            fontRegistry.removeListener((IPropertyChangeListener)this);
        }
        this.bodyOddRowBackgroundColor.dispose();
        this.headerSelectionBackgroundColor.dispose();
        this.headerFullSelectionBackgroundColor.dispose();
        this.headerPlaceholderColor.dispose();
    }

    private void updateFonts() {
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        this.baseFont = fontRegistry.get("org.eclipse.statet.workbench.themes.TableFont");
        this.infoFont = fontRegistry.getItalic("org.eclipse.statet.workbench.themes.TableFont");
        GC gc = new GC((Drawable)this.display);
        gc.setFont(this.baseFont);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int textHeight = fontMetrics.getHeight();
        int charWidth = (gc.textExtent((String)"1234567890.-120").x + 5) / 15;
        gc.dispose();
        int textSpace = 3;
        this.baseSizeConfig = new LayoutSizeConfig(3, textHeight, charWidth);
    }

    private void updateCellPainters() {
        this.baseCellPainter = new LineBorderDecorator((ICellPainter)new RTextPainter(this.baseSizeConfig.getDefaultSpace()));
        this.headerCellPainter = new RTextPainter(this.baseSizeConfig.getDefaultSpace());
        this.headerSortedCellPainter = new SortableHeaderTextPainter((ICellPainter)new RTextPainter(this.baseSizeConfig.getDefaultSpace()), true, true);
        this.headerCornerCellPainter = new DiagCellPainter(this.headerGridColor);
    }

    public void propertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "org.eclipse.statet.workbench.themes.TableFont": {
                this.updateFonts();
                this.updateCellPainters();
                this.notifyListeners();
                return;
            }
        }
    }

    public ILayerPainter getHeaderLayerPainter() {
        return this.headerLayerPainter;
    }

    public ILayerPainter getHeaderLabelLayerPainter() {
        return this.headerLabelLayerPainter;
    }

    public LayoutSizeConfig getBaseSizeConfig() {
        return this.baseSizeConfig;
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.bodyBackgroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.bodyForegroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.RIGHT);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyleAttributes.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.baseCellPainter);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle);
        configRegistry.registerConfigAttribute(LayoutSizeConfig.CONFIG, (Object)this.baseSizeConfig);
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.headerBackgroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.CENTER);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyleAttributes.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "COLUMN_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCellPainter, DisplayMode.NORMAL, "COLUMN_HEADER");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.headerBackgroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.RIGHT);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyleAttributes.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "COLUMN_HEADER_LABEL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCellPainter, DisplayMode.NORMAL, "COLUMN_HEADER_LABEL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "CORNER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCornerCellPainter, DisplayMode.NORMAL, "CORNER");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.headerBackgroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.RIGHT);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyleAttributes.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "ROW_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCellPainter, DisplayMode.NORMAL, "ROW_HEADER");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.headerBackgroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.LEFT);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyleAttributes.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "ROW_HEADER_LABEL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCellPainter, DisplayMode.NORMAL, "ROW_HEADER_LABEL");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.headerPlaceholderColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.RIGHT);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)this.baseFont);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "HEADER_PLACEHOLDER");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.bodyEvenRowBackgroundColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "EVEN_BODY");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.bodyOddRowBackgroundColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "ODD_BODY");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.bodySelectionBackgroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.bodySelectionForegroundColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT);
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, (Object)this.bodyAnchorBorderStyle);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "selectionAnchor");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "selectionAnchor");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.headerSelectionForegroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.headerSelectionBackgroundColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "COLUMN_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "CORNER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "ROW_HEADER");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)this.headerFullSelectionForegroundColor);
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.headerFullSelectionBackgroundColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "COLUMN_HEADER_FULL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "ROW_HEADER_FULL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerSortedCellPainter, DisplayMode.NORMAL, "SORT_DOWN");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerSortedCellPainter, DisplayMode.NORMAL, "SORT_UP");
        configRegistry.registerConfigAttribute(IFreezeConfigAttributes.SEPARATOR_COLOR, (Object)this.bodyFreezeSeparatorColor);
    }

    public void addListener(Runnable listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(Runnable listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyListeners() {
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }
}

