/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui;

import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;

public class ElementNameComparator
extends ViewerComparator
implements Comparator<IModelElement> {
    public ElementNameComparator(Comparator<? super ElementName> nameComparator) {
        super(nameComparator);
    }

    public int category(Object element) {
        return this.category((IModelElement)element);
    }

    public int category(IModelElement element) {
        switch (element.getElementType() & 0xF00) {
            case 768: {
                return 1;
            }
            case 1024: {
                return 2;
            }
        }
        return 100;
    }

    @Override
    public int compare(IModelElement e1, IModelElement e2) {
        int c2;
        int c1 = this.category(e1);
        if (c1 != (c2 = this.category(e2))) {
            return c1 - c2;
        }
        int result = this.getComparator().compare(e1.getElementName(), e2.getElementName());
        if (result != 0) {
            return result;
        }
        if (e1 instanceof ISourceStructElement && e2 instanceof ISourceStructElement) {
            return ((ISourceStructElement)e1).getSourceRange().getStartOffset() - ((ISourceStructElement)e2).getSourceRange().getStartOffset();
        }
        return 0;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof IModelElement) {
            if (e2 instanceof IModelElement) {
                return this.compare((IModelElement)e1, (IModelElement)e2);
            }
            return Integer.MIN_VALUE;
        }
        if (e2 instanceof IModelElement) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

