/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.util;

import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.internal.ecommons.debug.ui.Messages;

public class ProcessOutputCollector
extends Thread {
    private final String fName;
    private final ProcessBuilder fProcessBuilder;
    private Process fProcess;
    private boolean fIsRunning;
    private final IProgressMonitor fMonitor;
    private InputStreamReader fOutputInput;
    private final StringBuilder fBuffer;
    private Exception fReadException;

    public ProcessOutputCollector(ProcessBuilder processBuilder, String name, IProgressMonitor monitor) {
        super(String.valueOf(name) + "-Output Monitor");
        this.fProcessBuilder = processBuilder;
        this.fName = name;
        this.fMonitor = monitor;
        this.fBuffer = new StringBuilder();
    }

    public String collect() throws CoreException {
        try {
            this.fProcessBuilder.redirectErrorStream(true);
            this.fProcess = this.fProcessBuilder.start();
            this.fOutputInput = new InputStreamReader(this.fProcess.getInputStream());
        }
        catch (IOException e) {
            String cmdInfo = LaunchUtils.generateCommandLine(this.fProcessBuilder.command());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.base.ui", 0, NLS.bind((String)Messages.HelpRequestor_error_WhenRunProcess_message, (Object)this.fName, (Object)cmdInfo), (Throwable)e));
        }
        this.fIsRunning = true;
        this.fMonitor.worked(2);
        this.start();
        this.fMonitor.worked(1);
        while (this.fIsRunning) {
            try {
                this.fProcess.waitFor();
                this.fIsRunning = false;
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
        }
        this.fMonitor.worked(2);
        while (true) {
            try {
                this.join();
                if (this.fReadException != null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.base.ui", -1, NLS.bind((String)Messages.HelpRequestor_error_WhenReadOutput_message, (Object)this.fName), (Throwable)this.fReadException));
                }
                this.fMonitor.worked(2);
                return this.fBuffer.toString();
            }
            catch (InterruptedException e) {
                this.interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

