/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.markup;

import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupLanguageExtension2;
import org.eclipse.statet.ltk.core.SourceContent;

public class MarkupParser2
extends MarkupParser {
    public static final int GENERATIVE_CONTENT = 256;
    public static final int SOURCE_STRUCT = 4096;
    public static final int INLINE_MARKUP = 16;
    public static final int INLINE_EMBEDDED = 32;
    public static final int INLINE_ALL = 112;
    private static final int DEFAULT = 4080;
    private int currentFlags = 4080;

    public MarkupParser2(IMarkupLanguage markupLanguage, DocumentBuilder builder) {
        super((MarkupLanguage)markupLanguage, builder);
    }

    public MarkupParser2(IMarkupLanguage markupLanguage, DocumentBuilder builder, int initialFlags) {
        super((MarkupLanguage)markupLanguage, builder);
        this.currentFlags = initialFlags;
    }

    public MarkupParser2(MarkupParser parser0) {
        super(parser0.getMarkupLanguage(), parser0.getBuilder());
        MarkupLanguage markupLanguage = this.getMarkupLanguage();
        if (markupLanguage instanceof AbstractMarkupLanguage) {
            AbstractMarkupLanguage language = (AbstractMarkupLanguage)markupLanguage;
            this.setEnabled(256, !language.isFilterGenerativeContents());
            this.setEnabled(112, !language.isBlocksOnly());
        }
    }

    public void enable(int flags) {
        this.currentFlags |= flags;
    }

    public void disable(int flags) {
        this.currentFlags &= ~flags;
    }

    public void setEnabled(int flags, boolean enabled) {
        if (enabled) {
            this.enable(flags);
        } else {
            this.disable(flags);
        }
    }

    public int getFlags() {
        return this.currentFlags;
    }

    public boolean isEnabled(int flags) {
        return (this.currentFlags & flags) != 0;
    }

    public boolean isDisabled(int flags) {
        return (this.currentFlags & flags) == 0;
    }

    public void parse(SourceContent markupContent, boolean asDocument) {
        MarkupLanguage markupLanguage = this.getMarkupLanguage();
        DocumentBuilder builder = this.getBuilder();
        if (markupLanguage == null) {
            throw new IllegalStateException("markup language is not set");
        }
        if (builder == null) {
            throw new IllegalStateException("builder is not set");
        }
        if (markupLanguage instanceof MarkupLanguageExtension2) {
            ((MarkupLanguageExtension2)markupLanguage).processContent(this, markupContent, asDocument);
        } else {
            if (markupLanguage instanceof AbstractMarkupLanguage) {
                AbstractMarkupLanguage language = (AbstractMarkupLanguage)markupLanguage;
                language.setFilterGenerativeContents(this.isDisabled(256));
                language.setBlocksOnly(this.isDisabled(16));
            }
            markupLanguage.processContent((MarkupParser)this, markupContent.getText(), asDocument);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MarkupParser2");
        sb.append("\nlanguage= ").append(this.getMarkupLanguage().toString());
        sb.append("\nflags= ");
        if (this.currentFlags == 4080) {
            sb.append("(DEFAULT)");
        }
        sb.append("\n\tGENERATIVE_CONTENT= ").append(this.isEnabled(256));
        sb.append("\n\tSOURCE_STRUCT=      ").append(this.isEnabled(4096));
        sb.append("\n\tINLINE_MARKUP=      ").append(this.isEnabled(16));
        sb.append("\n\tINLINE_EMBEDDED=    ").append(this.isEnabled(32));
        sb.append("\n\tGENERATIVE_CONTENT= ").append(this.isEnabled(256));
        return sb.toString();
    }
}

