/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ThematicBreakBlock
extends SourceBlock {
    private static final Pattern PATTERN = Pattern.compile("(?:\\*[ \t]*){3,}|(?:-[ \t]*){3,}|(?:_[ \t]*){3,}", 32);
    private final Matcher matcher = PATTERN.matcher("");

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockItem<?> currentBlockItem) {
        return this.canStart(lineSequence.getCurrentLine());
    }

    public boolean canStart(@Nullable Line currentLine) {
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && currentLine.setupIndent(this.matcher).matches();
    }

    @Override
    public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
        SourceBlockItem<ThematicBreakBlock> blockItem = new SourceBlockItem<ThematicBreakBlock>(this, builder);
        lineSequence.advance();
    }

    @Override
    public void initializeContext(ProcessingContext context, SourceBlockItem<?> blockItem) {
    }

    @Override
    public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        locator.setBlockBegin(blockItem);
        builder.horizontalRule();
    }
}

