/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server.update;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.statet.internal.rhelp.server.update.REnvIndexer;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RLibPaths;

public class RLibPathsMonitor
implements Runnable {
    private final REnvIndexer indexer;
    private WatchService watchService;

    public RLibPathsMonitor(REnvIndexer indexer) {
        this.indexer = indexer;
    }

    public void check(RLibPaths rLibPaths) {
        try {
            this.ensureService();
            for (RLibLocation location : rLibPaths.getRLibLocations()) {
                Path path = location.getDirectoryPath();
                if (path == null || !Files.isDirectory(path, new LinkOption[0])) continue;
                path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
            }
        }
        catch (IOException e) {
            CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", String.format("%1$sAn error occurred when setting up R lib paths monitor.", this.indexer.getLogPrefix()), (Throwable)e));
        }
    }

    public void stop() {
        try {
            this.stopService();
        }
        catch (IOException e) {
            CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", String.format("%1$sAn error occurred when stopping R lib paths monitor.", this.indexer.getLogPrefix()), (Throwable)e));
        }
    }

    private synchronized void ensureService() throws IOException {
        if (this.watchService == null) {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.indexer.getController().startMonitor((Runnable)this);
        }
    }

    private synchronized void stopService() throws IOException {
        if (this.watchService != null) {
            this.watchService.close();
        }
    }

    private boolean isTempFolder(String fileName) {
        if (fileName.length() >= 5) {
            if (fileName.startsWith("_test_") || fileName.startsWith("_TEST_")) {
                return true;
            }
            if (fileName.startsWith("file") || fileName.startsWith("FILE")) {
                char c = fileName.charAt(4);
                return c >= '0' && c <= '9';
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            CommonsRuntime.log((Status)new InfoStatus("org.eclipse.statet.rhelp.server", String.format("%1$sR lib paths monitor started.", this.indexer.getLogPrefix())));
            boolean update = false;
            while (true) {
                try {
                    while (true) {
                        WatchKey key;
                        WatchKey watchKey = key = update ? this.watchService.poll(1000L, TimeUnit.MILLISECONDS) : this.watchService.take();
                        if (key == null) {
                            assert (update);
                            update = false;
                            this.indexer.schedule((byte)2);
                            continue;
                        }
                        List<WatchEvent<?>> events = key.pollEvents();
                        for (WatchEvent<?> event : events) {
                            if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                                update = true;
                                break;
                            }
                            Path path = (Path)event.context();
                            if (path == null || this.isTempFolder(path.getFileName().toString())) continue;
                            update = true;
                            break;
                        }
                        key.reset();
                    }
                }
                catch (InterruptedException key) {
                    continue;
                }
                catch (ClosedWatchServiceException e) {
                    RLibPathsMonitor rLibPathsMonitor = this;
                    synchronized (rLibPathsMonitor) {
                        this.watchService = null;
                    }
                    return;
                }
                break;
            }
        }
        catch (Throwable e) {
            CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", String.format("%1$sR lib paths monitor did not complete normally.", this.indexer.getLogPrefix()), e));
            return;
        }
    }
}

