/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.Embedded;
import org.eclipse.statet.docmlet.tex.core.ast.Environment;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.ast.TexAst;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstVisitor;
import org.eclipse.statet.docmlet.tex.core.ast.Text;
import org.eclipse.statet.docmlet.tex.core.commands.IPreambleDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.LtxPrintCommand;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.model.EmbeddingReconcileItem;
import org.eclipse.statet.docmlet.tex.core.model.ITexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.model.TexElementName;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.internal.docmlet.tex.core.model.EnvLabelAccess;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxSourceElement;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.internal.docmlet.tex.core.model.RefLabelAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.elements.NameAccessSet;
import org.eclipse.statet.ltk.model.core.impl.BasicNameAccessSet;
import org.eclipse.statet.ltk.model.core.impl.NameAccessAccumulator;

public class SourceAnalyzer
extends TexAstVisitor {
    private static final Integer ONE = 1;
    private String input;
    private LtxSourceElement.Container currentElement;
    private final StringBuilder titleBuilder = new StringBuilder();
    private boolean titleDoBuild;
    private LtxSourceElement.Container titleElement;
    private final Map<String, Integer> structNamesCounter = new HashMap<String, Integer>();
    private Map<String, NameAccessAccumulator<TexNameAccess>> labels = new HashMap<String, NameAccessAccumulator<TexNameAccess>>();
    private final List<EmbeddingReconcileItem> embeddedItems = new ArrayList<EmbeddingReconcileItem>();
    private int minSectionLevel;
    private int maxSectionLevel;

    public void clear() {
        this.input = null;
        this.currentElement = null;
        this.titleBuilder.setLength(0);
        this.titleDoBuild = false;
        this.titleElement = null;
        if (this.labels == null || !this.labels.isEmpty()) {
            this.labels = new HashMap<String, NameAccessAccumulator<TexNameAccess>>();
        }
        this.embeddedItems.clear();
        this.minSectionLevel = Integer.MAX_VALUE;
        this.maxSectionLevel = Integer.MIN_VALUE;
    }

    public LtxSourceUnitModelInfo createModel(ITexSourceUnit su, String input, AstInfo ast, Map<String, TexCommand> customCommands, Map<String, TexCommand> customEnvs) {
        this.clear();
        this.input = input;
        if (!(ast.getRoot() instanceof TexAstNode)) {
            return null;
        }
        this.currentElement = new LtxSourceElement.SourceContainer(528, su, (TexAstNode)ast.getRoot());
        LtxSourceElement.SourceContainer root = this.currentElement;
        try {
            BasicNameAccessSet labels;
            ((TexAstNode)ast.getRoot()).acceptInTex(this);
            if (this.labels.isEmpty()) {
                labels = BasicNameAccessSet.emptySet();
            } else {
                labels = new BasicNameAccessSet(this.labels);
                this.labels = null;
            }
            if (this.minSectionLevel == Integer.MAX_VALUE) {
                this.minSectionLevel = 0;
                this.maxSectionLevel = 0;
            }
            customCommands = customCommands != null ? Collections.unmodifiableMap(customCommands) : Collections.emptyMap();
            customEnvs = customEnvs != null ? Collections.unmodifiableMap(customEnvs) : Collections.emptyMap();
            LtxSourceUnitModelInfo model = new LtxSourceUnitModelInfo(ast, root, this.minSectionLevel, this.maxSectionLevel, (NameAccessSet<TexNameAccess>)labels, customCommands, customEnvs);
            return model;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException();
        }
    }

    public List<EmbeddingReconcileItem> getEmbeddedItems() {
        return this.embeddedItems;
    }

    private void initElement(LtxSourceElement.Container element) {
        if (this.currentElement.children.isEmpty()) {
            this.currentElement.children = new ArrayList<LtxSourceElement>();
        }
        this.currentElement.children.add(element);
        this.currentElement = element;
    }

    private void exitContainer(int stop, boolean forward) {
        this.currentElement.length = (forward ? this.readLinebreakForward(stop >= 0 ? stop : this.currentElement.startOffset + this.currentElement.length, this.input.length()) : this.readLinebreakBackward(stop >= 0 ? stop : this.currentElement.startOffset + this.currentElement.length, 0)) - this.currentElement.startOffset;
        List<LtxSourceElement> children = this.currentElement.children;
        if (!children.isEmpty()) {
            for (LtxSourceElement element : children) {
                if ((element.getElementType() & 0xFF0) != 1056) continue;
                Map<String, Integer> names = this.structNamesCounter;
                String name = element.getElementName().getDisplayName();
                Integer occ = names.get(name);
                if (occ == null) {
                    names.put(name, ONE);
                    continue;
                }
                element.occurrenceCount = occ + 1;
                names.put(name, element.occurrenceCount);
            }
            this.structNamesCounter.clear();
        }
        this.currentElement = this.currentElement.getModelParent();
    }

    private int readLinebreakForward(int offset, int limit) {
        if (offset < limit) {
            switch (this.input.charAt(offset)) {
                case '\n': {
                    if (++offset < limit && this.input.charAt(offset) == '\r') {
                        return ++offset;
                    }
                    return offset;
                }
                case '\r': {
                    if (++offset < limit && this.input.charAt(offset) == '\n') {
                        return ++offset;
                    }
                    return offset;
                }
            }
        }
        return offset;
    }

    private int readLinebreakBackward(int offset, int limit) {
        if (offset > limit) {
            switch (this.input.charAt(offset - 1)) {
                case '\n': {
                    if (--offset > limit && this.input.charAt(offset - 1) == '\r') {
                        return --offset;
                    }
                    return offset;
                }
                case '\r': {
                    if (--offset < limit && this.input.charAt(offset - 1) == '\n') {
                        return --offset;
                    }
                    return offset;
                }
            }
        }
        return offset;
    }

    private void finishTitleText() {
        boolean wasWhitespace = false;
        int idx = 0;
        while (idx < this.titleBuilder.length()) {
            if (this.titleBuilder.charAt(idx) == ' ') {
                if (wasWhitespace) {
                    this.titleBuilder.deleteCharAt(idx);
                    continue;
                }
                wasWhitespace = true;
                ++idx;
                continue;
            }
            wasWhitespace = false;
            ++idx;
        }
        this.titleElement.name = TexElementName.create(17, this.titleBuilder.toString());
        this.titleBuilder.setLength(0);
        this.titleElement = null;
        this.titleDoBuild = false;
    }

    @Override
    public void visit(SourceComponent node) throws InvocationTargetException {
        this.currentElement.startOffset = node.getStartOffset();
        node.acceptInTexChildren(this);
        if (this.titleElement != null) {
            this.finishTitleText();
        }
        while ((this.currentElement.getElementType() & 0xF00) != 512) {
            this.exitContainer(node.getEndOffset(), true);
        }
        this.exitContainer(node.getEndOffset(), true);
    }

    @Override
    public void visit(Environment node) throws InvocationTargetException {
        TexAstNode beginLabel;
        TexCommand command = node.getBeginNode().getCommand();
        if ((command.getType() & 0xFF) == 34) {
            if (this.titleElement != null) {
                this.finishTitleText();
            }
            while ((this.currentElement.getElementType() & 0xF00) != 512) {
                this.exitContainer(node.getStartOffset(), false);
            }
        }
        node.acceptInTexChildren(this);
        if ((command.getType() & 0xFF) == 34) {
            if (this.titleElement != null) {
                this.finishTitleText();
            }
            while ((this.currentElement.getElementType() & 0xF00) != 512) {
                this.exitContainer(node.getEndNode() != null ? node.getEndNode().getStartOffset() : node.getEndOffset(), false);
            }
        }
        if ((beginLabel = this.getLabelNode(node.getBeginNode())) != null) {
            TexAstNode endLabel = this.getLabelNode(node.getEndNode());
            ImList accessList = endLabel != null ? ImCollections.newList((Object[])new EnvLabelAccess[]{new EnvLabelAccess(node.getBeginNode(), beginLabel), new EnvLabelAccess(node.getEndNode(), endLabel)}) : ImCollections.newList((Object)new EnvLabelAccess(node.getBeginNode(), endLabel));
            for (EnvLabelAccess access : accessList) {
                access.all = accessList;
                access.getNode().addAttachment(access);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visit(ControlNode node) throws InvocationTargetException {
        block20: {
            command = node.getCommand();
            if (command == null) break block20;
            switch (command.getType() & 15) {
                case 4: {
                    if (command != IPreambleDefinitions.PREAMBLE_documentclass_COMMAND) break;
                    if (this.titleElement != null) {
                        this.finishTitleText();
                    }
                    while ((this.currentElement.getElementType() & 3840) != 512) {
                        this.exitContainer(node.getStartOffset(), false);
                    }
                    this.initElement(new LtxSourceElement.StructContainer(1040, this.currentElement, node));
                    this.currentElement.name = TexElementName.create(17, "Preamble");
                    break;
                }
                case 6: {
                    if ((this.currentElement.getElementType() & 4080) == 1040) {
                        this.exitContainer(node.getStartOffset(), false);
                    }
                    if ((this.currentElement.getElementType() & 4080) != 1056 && (this.currentElement.getElementType() & 3840) != 512 || (level = (command.getType() & 240) >> 4) > 5) break;
                    if (this.titleElement == null) ** GOTO lbl22
                    this.finishTitleText();
                    break;
lbl-1000:
                    // 1 sources

                    {
                        this.exitContainer(node.getStartOffset(), false);
lbl22:
                        // 2 sources

                        ** while ((this.currentElement.getElementType() & 4080) == 1056 && (this.currentElement.getElementType() & 15) >= level)
                    }
lbl23:
                    // 1 sources

                    this.initElement(new LtxSourceElement.StructContainer(1056 | level, this.currentElement, node));
                    this.minSectionLevel = Math.min(this.minSectionLevel, level);
                    this.maxSectionLevel = Math.max(this.maxSectionLevel, level);
                    count = node.getChildCount();
                    if (count > 0) {
                        this.titleElement = this.currentElement;
                        this.titleDoBuild = true;
                        titleNode = node.getChild(0);
                        this.titleElement.nameRegion = TexAst.getInnerRegion(titleNode);
                        node.getChild(0).acceptInTex(this);
                        if (this.titleElement != null) {
                            this.finishTitleText();
                        }
                        i = 1;
                        while (i < count) {
                            node.getChild(i).acceptInTex(this);
                            ++i;
                        }
                    } else {
                        this.currentElement.name = TexElementName.create(17, "");
                    }
                    this.currentElement.length = Math.max(this.currentElement.length, node.getLength());
                    return;
                }
                case 7: {
                    if ((command.getType() & 255) != 23) break;
                    nameNode = this.getLabelNode(node);
                    if (nameNode != null) {
                        label = nameNode.getText();
                        shared = this.labels.get(label);
                        if (shared == null) {
                            shared = new NameAccessAccumulator(label);
                            this.labels.put(label, (NameAccessAccumulator<TexNameAccess>)shared);
                        }
                        access = new RefLabelAccess((NameAccessAccumulator<TexNameAccess>)shared, node, nameNode);
                        if ((command.getType() & 4095) == 279) {
                            access.flags |= 2;
                        }
                        node.addAttachment(access);
                    }
                    prevDoBuild = this.titleDoBuild;
                    this.titleDoBuild = false;
                    node.acceptInTexChildren(this);
                    if (prevDoBuild && this.titleElement != null) {
                        this.titleDoBuild = true;
                    }
                    this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
                    return;
                }
                case 10: 
                case 11: {
                    if (!(command instanceof LtxPrintCommand) || !command.getArguments().isEmpty() || !this.titleDoBuild || (text = ((LtxPrintCommand)command).getText()) == null) break;
                    if (text.length() == 1 && Character.getType(text.charAt(0)) == 6) {
                        size = this.titleBuilder.length();
                        node.acceptInTexChildren(this);
                        if (this.titleElement != null && this.titleBuilder.length() == size + 1) {
                            this.titleBuilder.append(text);
                        }
                        this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
                        return;
                    }
                    this.titleBuilder.append(text);
                }
            }
        }
        node.acceptInTexChildren(this);
        this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
    }

    @Override
    public void visit(Text node) throws InvocationTargetException {
        if (this.titleDoBuild) {
            this.titleBuilder.append(this.input, node.getStartOffset(), node.getEndOffset());
            if (this.titleBuilder.length() >= 100) {
                this.finishTitleText();
            }
        }
        this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
    }

    @Override
    public void visit(Embedded node) throws InvocationTargetException {
        if ((node.getEmbedDescr() & 0xF) == 2) {
            if (this.titleDoBuild) {
                this.titleBuilder.append(this.input, node.getStartOffset(), node.getEndOffset());
                if (this.titleBuilder.length() >= 100) {
                    this.finishTitleText();
                }
            }
            this.embeddedItems.add(new EmbeddingReconcileItem(node, null));
        } else {
            if (this.titleElement != null) {
                this.finishTitleText();
            }
            if (this.currentElement.children.isEmpty()) {
                this.currentElement.children = new ArrayList<LtxSourceElement>();
            }
            LtxSourceElement.EmbeddedRef element = new LtxSourceElement.EmbeddedRef(node.getText(), this.currentElement, node);
            element.startOffset = node.getStartOffset();
            element.length = node.getLength();
            element.name = TexElementName.create(0, "");
            this.currentElement.children.add(element);
            this.embeddedItems.add(new EmbeddingReconcileItem(node, element));
        }
        this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
    }

    private TexAstNode getLabelNode(TexAstNode node) {
        if (node != null && node.getNodeType() == TexAst.NodeType.CONTROL && node.getChildCount() > 0) {
            if ((node = node.getChild(0)).getNodeType() == TexAst.NodeType.LABEL) {
                return node;
            }
            if (node.getNodeType() == TexAst.NodeType.GROUP && node.getChildCount() > 0 && (node = node.getChild(0)).getNodeType() == TexAst.NodeType.LABEL) {
                return node;
            }
        }
        return null;
    }
}

