/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ide.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.base.core.preferences.TaskTagsPreferences;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.ide.ui.StatetMessages;
import org.eclipse.statet.internal.ide.ui.preferences.Messages;
import org.eclipse.statet.internal.ide.ui.preferences.TaskTagsInputDialog;
import org.eclipse.statet.ltk.issues.core.ITaskTag;
import org.eclipse.statet.ltk.issues.core.impl.TaskTag;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class TaskTagsConfigurationBlock
extends ManagedConfigurationBlock {
    private final StatusChangeListener fStatusListener;
    private TableViewer listViewer;
    private ButtonGroup<ITaskTag> listButtons;
    private Image taskIcon;
    private Image taskDefaultIcon;
    private final IObservableList list;
    private final IObservableValue defaultValue;

    public TaskTagsConfigurationBlock(IProject project, StatusChangeListener statusListener) {
        super(project);
        this.fStatusListener = statusListener;
        this.list = new WritableList();
        this.defaultValue = new WritableValue();
    }

    final boolean isDefaultTask(ITaskTag task) {
        return this.defaultValue.getValue() == task;
    }

    protected String getHelpContext() {
        return "org.eclipse.statet.base.ui.task_tags_preferences";
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, String> prefs = new HashMap<Object, String>();
        prefs.put(TaskTagsPreferences.PREF_TAGS, "statet.task_tags");
        prefs.put(TaskTagsPreferences.PREF_PRIORITIES, "statet.task_tags");
        this.setupPreferenceManager(prefs);
        this.createImages();
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Composite table = this.createTable(composite);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listButtons = new ButtonGroup<ITaskTag>(composite){

            protected ITaskTag edit1(ITaskTag item, boolean newItem, Object parent) {
                TaskTagsInputDialog dialog = new TaskTagsInputDialog(this.getShell(), item, newItem, (List<TaskTag>)TaskTagsConfigurationBlock.this.list);
                if (dialog.open() == 0) {
                    return dialog.getResult();
                }
                return null;
            }

            public void updateState() {
                super.updateState();
                TaskTagsConfigurationBlock.this.saveTaskTags();
            }
        };
        this.listButtons.setLayoutData((Object)new GridData(4, 128, false, true));
        this.listButtons.addAddButton(null);
        this.listButtons.addCopyButton(null);
        this.listButtons.addEditButton(null);
        this.listButtons.addDeleteButton(null);
        this.listButtons.addSeparator();
        this.listButtons.addDefaultButton(null);
        this.listButtons.connectTo((StructuredViewer)this.listViewer, (IObservableCollection)this.list, this.defaultValue);
        this.listViewer.setInput((Object)this.list);
        this.updateControls();
    }

    protected Composite createTable(Composite parent) {
        ViewerUtils.TableComposite composite = new ViewerUtils.TableComposite(parent, 67586);
        this.listViewer = composite.viewer;
        composite.table.setHeaderVisible(true);
        composite.table.setLinesVisible(true);
        PixelConverter conv = new PixelConverter((Control)composite.table);
        TableViewerColumn column = new TableViewerColumn(composite.viewer, 16384);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.getColumn().setText(Messages.TaskTags_TaskColumn_name);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                ITaskTag tag = (ITaskTag)element;
                return TaskTagsConfigurationBlock.this.isDefaultTask(tag) ? TaskTagsConfigurationBlock.this.taskDefaultIcon : TaskTagsConfigurationBlock.this.taskIcon;
            }

            public String getText(Object element) {
                ITaskTag tag = (ITaskTag)element;
                return tag.getKeyword();
            }
        });
        column = new TableViewerColumn(composite.viewer, 16384);
        int priorityWidth = Messages.TaskTags_PriorityColumn_name.length();
        priorityWidth = Math.max(priorityWidth, StatetMessages.TaskPriority_High.length());
        priorityWidth = Math.max(priorityWidth, StatetMessages.TaskPriority_Normal.length());
        priorityWidth = Math.max(priorityWidth, StatetMessages.TaskPriority_Low.length());
        priorityWidth = conv.convertWidthInCharsToPixels(priorityWidth) + conv.convertHorizontalDLUsToPixels(5);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(priorityWidth, false, true));
        column.getColumn().setText(Messages.TaskTags_PriorityColumn_name);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITaskTag task = (ITaskTag)element;
                switch (task.getPriority()) {
                    case HIGH: {
                        return StatetMessages.TaskPriority_High;
                    }
                    case NORMAL: {
                        return StatetMessages.TaskPriority_Normal;
                    }
                    case LOW: {
                        return StatetMessages.TaskPriority_Low;
                    }
                }
                return "";
            }
        });
        composite.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        composite.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return this.getComparator().compare(((ITaskTag)e1).getKeyword(), ((ITaskTag)e2).getKeyword());
            }
        });
        return composite;
    }

    private void createImages() {
        Image baseImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_TASK_TSK");
        this.taskIcon = new DecorationOverlayIcon(baseImage, new ImageDescriptor[5], new Point(baseImage.getBounds().width + 4, baseImage.getBounds().height)).createImage();
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[3] = SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/ovr/default_marker");
        this.taskDefaultIcon = new DecorationOverlayIcon(baseImage, imageDescriptorArray, new Point(baseImage.getBounds().width + 4, baseImage.getBounds().height)).createImage();
    }

    public void dispose() {
        if (this.taskIcon != null) {
            this.taskIcon.dispose();
            this.taskIcon = null;
        }
        if (this.taskDefaultIcon != null) {
            this.taskDefaultIcon.dispose();
            this.taskDefaultIcon = null;
        }
        super.dispose();
    }

    protected void updateControls() {
        this.loadValues();
        this.listViewer.refresh();
        this.listButtons.updateState();
        ViewerUtils.scheduleStandardSelection((TableViewer)this.listViewer);
    }

    private void loadValues() {
        this.list.clear();
        TaskTagsPreferences taskPrefs = new TaskTagsPreferences((PreferenceAccess)this);
        this.list.addAll((Collection)taskPrefs.getTaskTags());
        if (!this.list.isEmpty()) {
            this.defaultValue.setValue(this.list.get(0));
        }
    }

    private void saveTaskTags() {
        ArrayList<TaskTag> taskTags = new ArrayList<TaskTag>((Collection<TaskTag>)this.list);
        TaskTag defaultTag = (TaskTag)this.defaultValue.getValue();
        if (defaultTag != null) {
            taskTags.remove(defaultTag);
            taskTags.add(0, defaultTag);
        }
        TaskTagsPreferences taskPrefs = new TaskTagsPreferences(taskTags);
        this.setPrefValues(taskPrefs.getPreferencesMap());
        this.validateSettings();
    }

    public void performDefaults() {
        super.performDefaults();
        this.validateSettings();
    }

    private IStatus validateSettings() {
        StatusInfo listStatus = new StatusInfo();
        if (this.list.size() == 0) {
            listStatus.setWarning(Messages.TaskTags_warning_NoTag_message);
        } else if (this.defaultValue.getValue() == null) {
            listStatus.setError(Messages.TaskTags_error_DefaultTast_message);
        }
        StatusInfo status = listStatus;
        this.fStatusListener.statusChanged((IStatus)status);
        return status;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.TaskTags_NeedsBuild_title;
        String message = workspaceSettings ? Messages.TaskTags_NeedsFullBuild_message : Messages.TaskTags_NeedsProjectBuild_message;
        return new String[]{title, message};
    }
}

