/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style;

import org.eclipse.statet.ecommons.waltable.persistence.ColorPersistor;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;

public class BorderStyle {
    private int thickness;
    private Color color;
    private LineStyle lineStyle;
    private int offset;

    public BorderStyle() {
        this(1, GUIHelper.COLOR_BLACK, LineStyle.SOLID, 0);
    }

    public BorderStyle(int thickness, Color color, LineStyle lineStyle) {
        this(thickness, color, lineStyle, 0);
    }

    public BorderStyle(int thickness, Color color, LineStyle lineStyle, int offset) {
        this.setThickness(thickness);
        this.setColor(color);
        this.setLineStyle(lineStyle);
        this.setOffset(offset);
    }

    public BorderStyle(String string) {
        String[] tokens = string.split("\\|");
        this.thickness = Integer.parseInt(tokens[0]);
        this.color = ColorPersistor.asColor(tokens[1]);
        this.lineStyle = LineStyle.valueOf(tokens[2]);
        if (tokens.length > 3) {
            this.offset = Integer.parseInt(tokens[3]);
        }
    }

    public int getThickness() {
        return this.thickness;
    }

    public Color getColor() {
        return this.color;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness > 0 ? thickness : 0;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        this.color = color;
    }

    public void setLineStyle(LineStyle lineStyle) {
        if (lineStyle == null) {
            throw new NullPointerException("lineStyle");
        }
        this.lineStyle = lineStyle;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int hashCode() {
        return (this.thickness * 13 + this.color.hashCode()) * 17 + this.lineStyle.hashCode() + this.offset * 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BorderStyle)) {
            return false;
        }
        BorderStyle that = (BorderStyle)obj;
        return this.thickness == that.thickness && this.color.equals((Object)that.color) && this.lineStyle == that.lineStyle && this.offset == that.offset;
    }

    public String toString() {
        return "" + this.thickness + '|' + ColorPersistor.asString(this.color) + '|' + (Object)((Object)this.lineStyle) + '|' + this.offset;
    }

    public static enum LineStyle {
        SOLID,
        DASHED,
        DOTTED,
        DASHDOT,
        DASHDOTDOT;

    }
}

