/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.CellVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.selection.ISelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;

public class CellSelectionEvent
extends CellVisualChangeEvent
implements ISelectionEvent {
    private final SelectionLayer selectionLayer;
    private final boolean revealCell;

    public CellSelectionEvent(SelectionLayer selectionLayer, long columnPosition, long rowPosition, boolean revealCell) {
        super(selectionLayer, columnPosition, rowPosition);
        this.selectionLayer = selectionLayer;
        this.revealCell = revealCell;
    }

    protected CellSelectionEvent(CellSelectionEvent event) {
        super(event);
        this.selectionLayer = event.selectionLayer;
        this.revealCell = event.revealCell;
    }

    @Override
    public CellSelectionEvent cloneEvent() {
        return new CellSelectionEvent(this);
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public boolean getRevealCell() {
        return this.revealCell;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        if (this.columnPosition == Long.MIN_VALUE || this.rowPosition == Long.MIN_VALUE) {
            return true;
        }
        return super.convertToLocal(localLayer);
    }
}

