/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.data;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.data.IColumnAccessor;
import org.eclipse.statet.ecommons.waltable.data.ListDataProvider;

public abstract class AbstractFilterListDataProvider<T>
extends ListDataProvider<T> {
    public AbstractFilterListDataProvider(List<T> list, IColumnAccessor<T> columnAccessor) {
        super(list, columnAccessor);
    }

    @Override
    public long getRowCount() {
        long numberOfInvisible = 0L;
        for (Object object : this.list) {
            if (this.show(object)) continue;
            ++numberOfInvisible;
        }
        return (long)this.list.size() - numberOfInvisible;
    }

    @Override
    public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
        T rowObj = this.getRowObject(rowIndex);
        return this.columnAccessor.getDataValue(rowObj, columnIndex);
    }

    @Override
    public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
        T rowObj = this.getRowObject(rowIndex);
        this.columnAccessor.setDataValue(rowObj, columnIndex, newValue);
    }

    @Override
    public T getRowObject(long rowIndex) {
        if (rowIndex >= Integer.MAX_VALUE) {
            return null;
        }
        T object = null;
        long count = 0L;
        int realRowIndex = 0;
        while (count <= rowIndex) {
            object = (T)this.list.get(realRowIndex);
            if (this.show(object)) {
                ++count;
            }
            ++realRowIndex;
        }
        return object;
    }

    @Override
    public long indexOfRowObject(T rowObject) {
        int realRowIndex;
        int filteredIndex = realRowIndex = this.list.indexOf(rowObject);
        T vf = null;
        int i = 0;
        while (i <= realRowIndex) {
            vf = (T)this.list.get(i);
            if (!this.show(vf)) {
                --filteredIndex;
            }
            ++i;
        }
        return filteredIndex;
    }

    protected abstract boolean show(T var1);
}

