/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceListAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.FilterLineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.BlockWithNestedBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ParagraphBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ThematicBreakBlock;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ListBlock
extends BlockWithNestedBlocks {
    public static final Pattern PATTERN = Pattern.compile("([*+-]|([0-9]{1,9})[.)])(?:([ \t]+)(.+)?)?", 32);
    private static final int MARKER_GROUP = 1;
    private static final int ORDERED_NUM_GROUP = 2;
    private static final int WHITESPACE_GROUP = 3;
    private static final int CONTENT_GROUP = 4;
    private final Matcher matcher = PATTERN.matcher("");
    private final ThematicBreakBlock thematicBreakBlock = new ThematicBreakBlock();

    public static int computeItemLineIndent(Line line, Matcher matcher) {
        int contentStartColumn;
        int markerEndColumn = line.getColumn(matcher.end(1));
        if (matcher.start(3) != -1 && matcher.start(4) != -1 && (contentStartColumn = line.getColumn(matcher.start(4))) - markerEndColumn <= 4) {
            return contentStartColumn - line.getColumn();
        }
        return markerEndColumn + 1 - line.getColumn();
    }

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockItem<?> currentBlockItem) {
        Matcher matcher;
        Line currentLine = lineSequence.getCurrentLine();
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && (matcher = currentLine.setupIndent(this.matcher)).matches() && (currentBlockItem == null || this.canInterrupt(currentLine, matcher, currentBlockItem));
    }

    private boolean canInterrupt(Line startLine, Matcher matcher, SourceBlockItem<?> currentBlockItem) {
        SourceBlockItem<?> parent = currentBlockItem.getParent();
        if (parent != null && parent.getType() instanceof ListItemBlock) {
            return true;
        }
        return this.listStart(startLine, matcher) == null && matcher.start(4) != -1;
    }

    @Override
    public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
        ListBlockItem listBlockItem = new ListBlockItem(this, builder);
        Line startLine = lineSequence.getCurrentLine();
        Matcher matcher = startLine.setupIndent(this.matcher);
        ListBlock.assertMatches(matcher);
        listBlockItem.bulletType = this.bulletType(startLine, matcher);
        listBlockItem.listStart = this.listStart(startLine, matcher);
        ListItemBlock itemBlock = new ListItemBlock(listBlockItem);
        builder.createNestedItems(new ListLines(lineSequence, builder, itemBlock), (ImList<? extends SourceBlock>)ImCollections.newList((Object)itemBlock));
    }

    @Override
    public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        ListBlockItem listBlockItem = (ListBlockItem)blockItem;
        SourceListAttributes listAttributes = new SourceListAttributes(256);
        listAttributes.setStart(listBlockItem.listStart);
        ListMode listMode = context.getMode() == 3 ? ListMode.LOOSE : this.calculateListMode(listBlockItem);
        locator.setBlockBegin(blockItem);
        builder.beginBlock(this.toBlockType(listBlockItem.bulletType), (Attributes)listAttributes);
        for (SourceBlockItem<?> nestedBlockItem : listBlockItem.getNested()) {
            ((ListItemBlock)nestedBlockItem.getType()).emit(context, nestedBlockItem, listMode, locator, builder);
        }
        locator.setBlockEnd(blockItem);
        builder.endBlock();
    }

    private ListMode calculateListMode(ListBlockItem listBlockItem) {
        ListMode listMode = ListMode.TIGHT;
        for (SourceBlockItem<?> itemBlockItem : listBlockItem.getNested()) {
            switch (listMode) {
                case LOOSE: 
                case TIGHT_WITH_TRAILING_EMPTY_LINE: {
                    return ListMode.LOOSE;
                }
                case TIGHT: {
                    listMode = this.getListItemListMode(itemBlockItem);
                }
            }
        }
        return listMode == ListMode.TIGHT_WITH_TRAILING_EMPTY_LINE ? ListMode.TIGHT : listMode;
    }

    private ListMode getListItemListMode(SourceBlockItem<?> itemBlockItem) {
        List<SourceBlockItem<?>> contentBlockItems = itemBlockItem.getNested();
        if (contentBlockItems.isEmpty()) {
            return ListMode.TIGHT;
        }
        SourceBlockItem<?> block = contentBlockItems.get(0);
        if (block.isEmpty() && block.getLines().size() > 1) {
            return ListMode.LOOSE;
        }
        int idx = 1;
        while (idx < contentBlockItems.size() - 1) {
            SourceBlockItem<?> block2 = contentBlockItems.get(idx);
            if (block2.isEmpty()) {
                return ListMode.LOOSE;
            }
            ++idx;
        }
        if (contentBlockItems.size() > 1 && (block = contentBlockItems.get(contentBlockItems.size() - 1)).isEmpty()) {
            return ListMode.TIGHT_WITH_TRAILING_EMPTY_LINE;
        }
        return ListMode.TIGHT;
    }

    private char bulletType(Line line, Matcher matcher) {
        return line.getText().charAt(matcher.end(1) - 1);
    }

    private @Nullable String listStart(Line line, Matcher matcher) {
        String number = matcher.group(2);
        if (number != null) {
            int startIdx = 0;
            while (startIdx < number.length() - 1) {
                if (number.charAt(startIdx) != '0') break;
                ++startIdx;
            }
            if (startIdx > 0) {
                number = number.substring(startIdx);
            }
            if (number.equals("1")) {
                return null;
            }
            return number;
        }
        return null;
    }

    private DocumentBuilder.BlockType toBlockType(char bulletType) {
        switch (bulletType) {
            case '*': 
            case '+': 
            case '-': {
                return DocumentBuilder.BlockType.BULLETED_LIST;
            }
        }
        return DocumentBuilder.BlockType.NUMERIC_LIST;
    }

    private static final class ListBlockItem
    extends SourceBlockItem<ListBlock> {
        private char bulletType;
        private @Nullable String listStart;

        public ListBlockItem(ListBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }
    }

    private static class ListItemBlock
    extends BlockWithNestedBlocks {
        private final ListBlockItem listBlockItem;
        private int itemIdent = 4;

        public ListItemBlock(ListBlockItem listBlockItem) {
            this.listBlockItem = listBlockItem;
        }

        @Override
        public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockItem<?> currentBlockItem) {
            return this.canStart(lineSequence.getCurrentLine());
        }

        public boolean canStart(@Nullable Line startLine) {
            if (startLine != null && !startLine.isBlank() && startLine.getIndent() < this.itemIdent) {
                ListBlock listBlock = (ListBlock)this.listBlockItem.getType();
                Matcher matcher = startLine.setupIndent(listBlock.matcher);
                return matcher.matches() && listBlock.bulletType(startLine, matcher) == this.listBlockItem.bulletType && !listBlock.thematicBreakBlock.canStart(startLine);
            }
            return false;
        }

        @Override
        public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
            SourceBlockItem<ListItemBlock> blockItem = new SourceBlockItem<ListItemBlock>(this, builder);
            Line startLine = lineSequence.getCurrentLine();
            ListBlock listBlock = (ListBlock)this.listBlockItem.getType();
            this.itemIdent = ListBlock.computeItemLineIndent(startLine, listBlock.matcher);
            ListItemLines itemLineSequence = new ListItemLines(lineSequence, builder, blockItem, startLine.getLineNumber(), this.itemIdent);
            builder.createNestedItems(itemLineSequence, null);
        }

        @Override
        public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
            throw new UnsupportedOperationException();
        }

        public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, ListMode listMode, CommonmarkLocator locator, DocumentBuilder builder) {
            SourceElementAttributes attributes = new SourceElementAttributes(256);
            locator.setBlockBegin(blockItem);
            builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, (Attributes)attributes);
            for (SourceBlockItem<?> contentBlockItem : blockItem.getNested()) {
                if (listMode == ListMode.TIGHT && contentBlockItem.isParagraph()) {
                    ((ParagraphBlock)contentBlockItem.getType()).emit(context, contentBlockItem, false, locator, builder);
                    continue;
                }
                ((SourceBlock)contentBlockItem.getType()).emit(context, contentBlockItem, locator, builder);
            }
            locator.setBlockEnd(blockItem);
            builder.endBlock();
        }
    }

    private static class ListItemLines
    extends FilterLineSequence {
        private final SourceBlocks.SourceBlockBuilder builder;
        private final SourceBlockItem<ListItemBlock> blockItem;
        private final int markerLineNumber;
        private final int indent;

        public ListItemLines(LineSequence delegate, SourceBlocks.SourceBlockBuilder builder, SourceBlockItem<ListItemBlock> blockItem, int markerLineNumber, int indent) {
            super(delegate);
            this.builder = builder;
            this.blockItem = blockItem;
            this.markerLineNumber = markerLineNumber;
            this.indent = indent;
        }

        protected ListItemLines(ListItemLines from) {
            super(from.getDelegate().lookAhead());
            this.builder = from.builder;
            this.blockItem = from.blockItem;
            this.markerLineNumber = from.markerLineNumber;
            this.indent = from.indent;
        }

        @Override
        public ListItemLines lookAhead() {
            return new ListItemLines(this);
        }

        @Override
        protected @Nullable Line filter(Line line) {
            List<SourceBlockItem<?>> nestedItems = this.blockItem.getNested();
            if (nestedItems.size() == 1 && nestedItems.get(0).isEmpty() && line.getLineNumber() > this.markerLineNumber + 1) {
                return null;
            }
            if (line.isLazy()) {
                return line;
            }
            if (line.getLineNumber() == this.markerLineNumber || line.isBlank() || line.getIndent() >= this.indent) {
                return line.segmentByIndent(this.indent);
            }
            return null;
        }
    }

    private static class ListLines
    extends FilterLineSequence {
        private final SourceBlocks.SourceBlockBuilder builder;
        private final ListItemBlock listItemBlock;

        public ListLines(LineSequence delegate, SourceBlocks.SourceBlockBuilder builder, ListItemBlock blockItem) {
            super(delegate);
            this.builder = builder;
            this.listItemBlock = blockItem;
        }

        public ListLines(ListLines from) {
            super(from.getDelegate().lookAhead());
            this.builder = from.builder;
            this.listItemBlock = from.listItemBlock;
        }

        @Override
        public LineSequence lookAhead() {
            return new ListLines(this);
        }

        @Override
        protected @Nullable Line filter(Line line) {
            if (!line.isBlank()) {
                if (line.getIndent() >= this.listItemBlock.itemIdent || this.listItemBlock.canStart(line)) {
                    return line;
                }
                if (this.isLazyContinuation(line)) {
                    return line.lazy();
                }
            } else if (this.lookAheadSafeLine(this.getDelegate().lookAhead(line.getLineNumber())) != Integer.MIN_VALUE) {
                return line;
            }
            return null;
        }

        private boolean isLazyContinuation(Line line) {
            SourceBlockItem<?> currentItem = this.builder.getCurrentItem();
            return currentItem.getParent() != this.listItemBlock.listBlockItem && currentItem.isParagraph() && !this.listItemBlock.canStart(line) && !((ParagraphBlock)currentItem.getType()).isAnotherBlockStart(this.getDelegate().lookAhead(line.getLineNumber()), this.builder.getSourceBlocks(), currentItem);
        }

        private int lookAheadSafeLine(LineSequence lineSequence) {
            Line line;
            while ((line = lineSequence.getCurrentLine()) != null) {
                if (line.isBlank()) {
                    lineSequence.advance();
                    continue;
                }
                if (line.getIndent() < this.listItemBlock.itemIdent && !this.listItemBlock.canStart(line)) break;
                return line.getLineNumber();
            }
            return Integer.MIN_VALUE;
        }
    }

    private static enum ListMode {
        TIGHT,
        LOOSE,
        TIGHT_WITH_TRAILING_EMPTY_LINE;

    }
}

