/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.pkgmanager;

import java.util.List;
import org.eclipse.statet.r.core.pkgmanager.ISelectedRepos;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.core.pkgmanager.RRepo;

public class SelectedRepos
implements ISelectedRepos {
    private final List<RRepo> repos;
    private final RRepo cranMirror;
    private final String biocVersion;
    private final RRepo biocMirror;

    public SelectedRepos(List<RRepo> repos, RRepo cranMirror, String bioCVersion, RRepo bioCMirror) {
        this.repos = repos;
        this.cranMirror = cranMirror;
        this.biocVersion = bioCVersion;
        this.biocMirror = bioCMirror;
    }

    public List<RRepo> getRepos() {
        return this.repos;
    }

    @Override
    public RRepo getRepo(String repoId) {
        if (repoId == "special-ws-cache-source") {
            return RRepo.WS_CACHE_SOURCE_REPO;
        }
        if (repoId == "special-ws-cache-binary") {
            return RRepo.WS_CACHE_BINARY_REPO;
        }
        return RPkgUtils.getRepoById(this.repos, repoId);
    }

    @Override
    public RRepo getCRANMirror() {
        return this.cranMirror;
    }

    @Override
    public RRepo getBioCMirror() {
        return this.biocMirror;
    }

    @Override
    public String getBioCVersion() {
        return this.biocVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ISelectedRepos)) {
            return false;
        }
        ISelectedRepos other = (ISelectedRepos)obj;
        return this.repos.equals(other.getRepos()) && (this.cranMirror != null ? this.cranMirror.equals(other.getCRANMirror()) : other.getCRANMirror() == null) && (this.biocMirror != null ? this.biocMirror.equals(other.getBioCMirror()) : other.getBioCMirror() == null);
    }
}

