/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.io.internal.Messages;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.ecommons.coreutils.CoreMiscellanyPlugin;

public class FileValidator
implements IValidator {
    private Object explicitObject;
    private boolean inCheck = false;
    private IResource workspaceResource;
    private IFileStore fileStore;
    private IStatus status;
    private String resourceLabel;
    private VariableText2 variableResolver;
    private int onEmpty = 4;
    private int onNotExisting = 0;
    private int onExisting = 0;
    private VariableText2.Severities onVariableProblems = VariableText2.Severities.RESOLVE;
    private int onFile = 0;
    private int onDirectory = 0;
    private int onNotLocal = 4;
    private boolean ignoreRelative = false;
    private IStringVariable relativePrefix;
    private int relativeMax = -1;
    private IPath relativePath;
    private boolean requireWorkspace;
    private boolean asWorkspacePath;
    private Map<Pattern, Integer> onPattern;
    private IValidator fileStoreValidator;
    private int currentMax;

    public FileValidator() {
    }

    public FileValidator(boolean existingResource) {
        this();
        this.setDefaultMode(existingResource);
    }

    public void setDefaultMode(boolean existingResource) {
        this.onNotExisting = existingResource ? 4 : 0;
        this.onExisting = existingResource ? 0 : 2;
    }

    void checkVariable(IStringVariable variable) {
    }

    public void setOnEmpty(int severity) {
        this.onEmpty = severity;
        this.resetResolution();
    }

    public int getOnEmpty() {
        return this.onEmpty;
    }

    public void setOnExisting(int severity) {
        this.onExisting = severity;
        this.resetResolution();
    }

    public int getOnExisting() {
        return this.onExisting;
    }

    public void setOnNotExisting(int severity) {
        this.onNotExisting = severity;
        this.resetResolution();
    }

    public int getOnNotExisting() {
        return this.onNotExisting;
    }

    public void setOnLateResolve(int severity) {
        if (severity != this.onVariableProblems.getUnresolved()) {
            this.onVariableProblems = new VariableText2.Severities(4, severity);
        }
        this.resetResolution();
    }

    public int getOnLateResolve() {
        return this.onVariableProblems.getUnresolved();
    }

    public void setOnFile(int severity) {
        this.onFile = severity;
        this.resetResolution();
    }

    public int getOnFile() {
        return this.onFile;
    }

    public void setOnDirectory(int severity) {
        this.onDirectory = severity;
        this.resetResolution();
    }

    public int getOnDirectory() {
        return this.onDirectory;
    }

    public void setOnNotLocal(int severity) {
        this.onNotLocal = severity;
        this.resetResolution();
    }

    public int getOnNotLocal() {
        return this.onNotLocal;
    }

    public void setIgnoreRelative(boolean ignore) {
        this.relativeMax = -1;
        this.ignoreRelative = ignore;
        this.resetResolution();
    }

    public void setRelative(IStringVariable prefix, int maxSeverity) {
        this.relativePrefix = prefix;
        this.relativeMax = maxSeverity;
        this.ignoreRelative = false;
        this.checkVariable(prefix);
        this.resetResolution();
    }

    protected String getRelativePrefix() {
        String prefix = null;
        if (this.relativePrefix != null) {
            try {
                prefix = VariableUtils.getValue(this.relativePrefix);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (prefix != null && !prefix.endsWith("/") && !prefix.endsWith("\\")) {
            prefix = String.valueOf(prefix) + '/';
        }
        return prefix;
    }

    public void setRequireWorkspace(boolean require, boolean wsPath) {
        this.requireWorkspace = require;
        if (require) {
            this.asWorkspacePath = wsPath;
        }
        this.resetResolution();
    }

    public void setVariableResolver(VariableText2 variableResolver) {
        this.variableResolver = variableResolver;
        if (variableResolver.getExtraVariables() != null) {
            for (IStringVariable aVariable : variableResolver.getExtraVariables().values()) {
                this.checkVariable(aVariable);
            }
        }
        this.updateVariableResolution();
    }

    public VariableText2 getVariableResolver() {
        return this.variableResolver;
    }

    public void updateVariableResolution() {
        if (this.explicitObject instanceof String || this.relativePrefix != null) {
            this.resetResolution();
        }
    }

    public void setOnPattern(Pattern pattern, int severity) {
        if (this.onPattern == null) {
            this.onPattern = new LinkedHashMap<Pattern, Integer>();
        }
        if (severity >= 0) {
            this.onPattern.put(pattern, severity);
        } else {
            this.onPattern.remove(pattern);
        }
    }

    public int getOnPattern(Pattern pattern) {
        Integer integer;
        if (this.onPattern != null && (integer = this.onPattern.get(pattern)) != null) {
            return integer;
        }
        return -1;
    }

    public void setFileStoreValidator(IValidator validator) {
        this.fileStoreValidator = validator;
    }

    public void setResourceLabel(String label) {
        this.resourceLabel = label;
    }

    public void setExplicit(Object value) {
        this.fileStore = null;
        this.workspaceResource = null;
        this.explicitObject = value;
        this.setStatus(null);
    }

    private void resetResolution() {
        this.fileStore = null;
        this.workspaceResource = null;
        this.setStatus(null);
    }

    protected void setStatus(IStatus status) {
        this.status = status;
    }

    public IStatus validate(Object value) {
        if (!this.checkExplicit()) {
            this.doValidateChecked(value);
        }
        return this.status;
    }

    boolean checkExplicit() {
        if (this.explicitObject != null) {
            if (this.status == null) {
                this.doValidateChecked(this.explicitObject);
            }
            return true;
        }
        return false;
    }

    private void doValidateChecked(Object value) {
        if (!this.inCheck) {
            this.inCheck = true;
            try {
                try {
                    IStatus status2;
                    IStatus status = this.doValidate1(value);
                    if (status.getSeverity() < 4 && this.fileStoreValidator != null && (status2 = this.fileStoreValidator.validate((Object)this.getFileStore())) != null && status2.getSeverity() > status.getSeverity()) {
                        status = status2;
                    }
                    this.setStatus(status);
                }
                catch (Exception e) {
                    CoreMiscellanyPlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", NLS.bind((String)"An error occurred when validating resource path ({0}).", (Object)value), (Throwable)e));
                    this.inCheck = false;
                }
            }
            finally {
                this.inCheck = false;
            }
        }
    }

    private IStatus doValidate1(Object value) {
        this.fileStore = null;
        this.workspaceResource = null;
        this.relativePath = null;
        this.currentMax = Integer.MAX_VALUE;
        if (value instanceof IPath) {
            value = ((IPath)value).toOSString();
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.length() == 0) {
                return this.createStatus(this.onEmpty, Messages.Resource_error_NoInput_message, Messages.Resource_error_NoInput_message_0, null);
            }
            if (this.onPattern != null && !this.onPattern.isEmpty()) {
                for (Map.Entry<Pattern, Integer> entry : this.onPattern.entrySet()) {
                    if (!entry.getKey().matcher(s).find()) continue;
                    return Status.OK_STATUS;
                }
            }
            try {
                s = this.resolveExpression(s);
            }
            catch (CoreException e) {
                return this.createStatus(e.getStatus().getSeverity(), Messages.Resource_error_Other_message, Messages.Resource_error_Other_message_0, e.getStatus().getMessage());
            }
            if (s.length() == 0) {
                return this.createStatus(this.onEmpty, Messages.Resource_error_NoInput_message, Messages.Resource_error_NoInput_message_0, null);
            }
            Path path = new Path(s);
            if (!path.isAbsolute()) {
                String prefix;
                this.relativePath = path;
                if (this.relativeMax >= 0 && this.relativeMax < this.currentMax) {
                    this.currentMax = this.relativeMax;
                }
                if ((prefix = this.getRelativePrefix()) != null) {
                    s = String.valueOf(prefix) + s;
                } else if (this.ignoreRelative) {
                    return Status.OK_STATUS;
                }
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (this.asWorkspacePath) {
                int typeMask = (this.onFile < 4 ? 1 : 0) | (this.onDirectory < 4 ? 6 : 0);
                IStatus status = workspace.validatePath(s, typeMask);
                if (!status.isOK()) {
                    return this.createStatus(status.getSeverity(), Messages.Resource_error_Other_message, Messages.Resource_error_Other_message_0, status.getMessage());
                }
                Path path2 = new Path(s);
                this.workspaceResource = workspace.getRoot().findMember((IPath)path2, true);
                if (this.workspaceResource == null) {
                    IResource project = workspace.getRoot().findMember(path2.segment(0), true);
                    if (project == null) {
                        return this.createStatus(4, Messages.Resource_error_NotInWorkspace_message, Messages.Resource_error_NotInWorkspace_message_0, null);
                    }
                    this.workspaceResource = path2.segmentCount() == 1 && this.onDirectory < 4 ? project : (this.onDirectory < this.onFile ? workspace.getRoot().getFolder((IPath)path2) : workspace.getRoot().getFile((IPath)path2));
                }
            } else {
                try {
                    this.fileStore = FileUtil.getFileStore(s);
                    if (this.fileStore == null) {
                        return this.createStatus(4, Messages.Resource_error_NoValidSpecification_message, Messages.Resource_error_NoValidSpecification_message_0, null);
                    }
                }
                catch (CoreException e) {
                    return this.createStatus(4, Messages.Resource_error_NoValidSpecification_message, Messages.Resource_error_NoValidSpecification_message_0, e.getStatus().getMessage());
                }
                if (this.fileStore != null) {
                    IContainer[] resources;
                    Object[] objectArray = resources = this.fileStore.fetchInfo().isDirectory() ? workspace.getRoot().findContainersForLocationURI(this.fileStore.toURI()) : workspace.getRoot().findFilesForLocationURI(this.fileStore.toURI());
                    if (resources.length > 0) {
                        this.workspaceResource = resources[0];
                    }
                }
            }
        }
        if (value instanceof IFileStore) {
            this.fileStore = (IFileStore)value;
        } else if (value instanceof IResource) {
            this.workspaceResource = (IResource)value;
        }
        if (!this.requireWorkspace && this.fileStore != null) {
            return this.validateFileStore();
        }
        if (this.workspaceResource != null) {
            return this.validateWorkspaceResource();
        }
        if (this.requireWorkspace) {
            return this.createStatus(4, Messages.Resource_error_NotInWorkspace_message, Messages.Resource_error_NotInWorkspace_message_0, null);
        }
        throw new IllegalArgumentException();
    }

    protected String resolveExpression(String expression) throws CoreException {
        if (this.variableResolver != null) {
            return this.variableResolver.performStringSubstitution(expression, this.onVariableProblems);
        }
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return manager.performStringSubstitution(expression);
        }
        catch (CoreException e) {
            manager.validateStringVariables(expression);
            throw new CoreException((IStatus)new Status(this.getOnLateResolve(), e.getStatus().getPlugin(), e.getStatus().getMessage()));
        }
    }

    private IResource findWorkspaceResource(URI location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] found = null;
        if (this.onFile != 4) {
            found = root.findFilesForLocationURI(location);
        }
        if ((found == null || found.length == 0) && this.onDirectory != 4) {
            found = root.findContainersForLocationURI(location);
        }
        if (found != null && found.length > 0) {
            return found[0];
        }
        return null;
    }

    protected IStatus validateWorkspaceResource() {
        IStatus status = Status.OK_STATUS;
        if (this.onNotLocal != 0) {
            if (!this.isLocalFile()) {
                status = this.createStatus(this.onNotLocal, Messages.Resource_error_NotLocal_message, Messages.Resource_error_NotLocal_message_0, null);
            }
            if (status.getSeverity() == 4) {
                return status;
            }
        }
        if (this.onExisting != 0 || this.onNotExisting != 0 || this.onFile != 0 || this.onDirectory != 0) {
            status = StatusUtils.getMoreSevere((IStatus)status, (IStatus)this.createExistsStatus(this.workspaceResource.exists(), this.workspaceResource instanceof IContainer));
        }
        return status;
    }

    protected IStatus validateFileStore() {
        IStatus status = Status.OK_STATUS;
        if (this.onNotLocal != 0) {
            if (!this.isLocalFile()) {
                status = this.createStatus(this.onNotLocal, Messages.Resource_error_NotLocal_message, Messages.Resource_error_NotLocal_message_0, null);
            }
            if (status.getSeverity() == 4) {
                return status;
            }
        }
        if (this.onExisting != 0 || this.onNotExisting != 0) {
            IFileInfo info = this.fileStore.fetchInfo();
            status = StatusUtils.getMoreSevere((IStatus)status, (IStatus)this.createExistsStatus(info.exists(), info.isDirectory()));
        }
        return status;
    }

    private IStatus createExistsStatus(boolean exists, boolean isDirectory) {
        if (exists) {
            IStatus status = this.createStatus(this.onExisting, Messages.Resource_error_AlreadyExists_message, Messages.Resource_error_AlreadyExists_message_0, null);
            if (status.getSeverity() < this.onDirectory && isDirectory) {
                status = this.createStatus(this.onDirectory, Messages.Resource_error_IsDirectory_message, Messages.Resource_error_IsDirectory_message_0, null);
            }
            if (status.getSeverity() < this.onFile && !isDirectory) {
                status = this.createStatus(this.onFile, Messages.Resource_error_IsFile_message, Messages.Resource_error_IsFile_message_0, null);
            }
            return status;
        }
        return this.createStatus(this.onNotExisting, Messages.Resource_error_DoesNotExists_message, Messages.Resource_error_DoesNotExists_message_0, null);
    }

    protected IStatus createStatus(int severity, String message, String message0, String detail) {
        if (severity == 0) {
            return Status.OK_STATUS;
        }
        if (severity > this.currentMax) {
            severity = this.currentMax;
        }
        if (detail == null) {
            detail = "";
        }
        return new Status(severity, "org.eclipse.statet.ecommons.coremisc", this.resourceLabel != null ? NLS.bind((String)message, (Object)this.resourceLabel, (Object)detail) : NLS.bind((String)message0, (Object)detail));
    }

    public IFileStore getFileStore() {
        this.checkExplicit();
        if (this.fileStore == null && this.workspaceResource != null) {
            try {
                this.fileStore = EFS.getStore((URI)this.workspaceResource.getLocationURI());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.fileStore;
    }

    public IResource getWorkspaceResource() {
        this.checkExplicit();
        if (this.workspaceResource == null && this.fileStore != null) {
            this.workspaceResource = this.findWorkspaceResource(this.fileStore.toURI());
        }
        return this.workspaceResource;
    }

    public boolean isLocalFile() {
        IFileStore fileStore = this.getFileStore();
        if (fileStore != null) {
            return fileStore.getFileSystem().equals(EFS.getLocalFileSystem());
        }
        return false;
    }

    public boolean isRelativeFile() {
        return this.relativePath != null;
    }

    public IPath getRelativeFile() {
        return this.relativePath;
    }

    public IStatus getStatus() {
        this.checkExplicit();
        return this.status;
    }
}

